# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		BEDTools
Version:	2.27.1
Release:	alt1_1
Summary:	A flexible suite of utilities for comparing genomic features
Group:		Engineering
License:	GPLv2+
URL:		https://github.com/arq5x/bedtools2
Source0:	https://github.com/arq5x/bedtools2/releases/download/v%{version}/bedtools-%{version}.tar.gz
#Fix debuginfo canonicalization error
Patch0:		BEDTools-double-parenthesis.patch
# Fix very bizarre mess in the sphinx config which breaks build:
# https://github.com/arq5x/bedtools2/pull/625
Patch1:		0001-Ditch-bizarre-inclusion-then-mock-out-of-matplotlib-.patch

BuildRequires:	  zlib-devel
BuildRequires:	  python
BuildRequires:	  python-module-sphinx
Source44: import.info

%description

The BEDTools utilities allow one to address common genomics tasks such
as finding feature overlaps and computing coverage. The utilities are
largely based on four widely-used file formats: BED, GFF/GTF, VCF, and
SAM/BAM. Using BEDTools, one can develop sophisticated pipelines that
answer complicated research questions by "streaming" several BEDTools
together. 

%prep
%setup -q -n bedtools2
%patch0 -p1
%patch1 -p1
# remove bundled curl library
rm -rf src/utils/curl


%build
# gzstream includes a local header file
%make_build CXXFLAGS="-I. %{optflags}" V=1
cd docs
make clean html
cd ..


%install
mkdir -p %{buildroot}%{_bindir}
install -m 0755 bin/* %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_datadir}/%{name}
cp -a genomes/ %{buildroot}%{_datadir}/%{name}
cp -a data/ %{buildroot}%{_datadir}/%{name}
# fix permissions
find %{buildroot}%{_datadir}/%{name} -type f -exec chmod 0644 {} \;


%files
%doc README.md RELEASE_HISTORY docs/_build/html/
%doc --no-dereference LICENSE
%dir %{_datadir}/%{name}
%{_bindir}/*
%{_datadir}/%{name}/genomes
%{_datadir}/%{name}/data

%changelog
