Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname colorspace
%global packver  2.0-3
%global rlibdir  %{_libdir}/R/library

%global __suggests_exclude ^R\\((kernlab|rcartocolor|scico|shinyjs|vcd|viridis)\\)

# Not yet available.
%global with_suggests 0

Name:             R-%{packname}
Version:          2.0.3
Release:          alt1_14
Summary:          A Toolbox for Manipulating and Assessing Colors and Palettes

# Automatically converted from old format: BSD - review is highly recommended.
License:          LicenseRef-Callaway-BSD
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz

# Here's the R view of the dependencies world:
# Depends:   R-methods
# Imports:   R-graphics, R-grDevices, R-stats
# Suggests:  R-datasets, R-utils, R-KernSmooth, R-MASS, R-kernlab, R-mvtnorm, R-vcd, R-tcltk, R-shiny, R-shinyjs, R-ggplot2, R-dplyr, R-scales, R-grid, R-png, R-jpeg, R-knitr, R-rmarkdown, R-RColorBrewer, R-rcartocolor, R-scico, R-viridis, R-wesanderson
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
%if %{with_suggests}
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-kernlab
BuildRequires:    R-mvtnorm
BuildRequires:    R-vcd
BuildRequires:    R-tcltk
BuildRequires:    R-shiny
BuildRequires:    R-shinyjs
BuildRequires:    R-ggplot2
BuildRequires:    R-dplyr
BuildRequires:    R-scales
BuildRequires:    R-base R-tcltk
BuildRequires:    R-png
BuildRequires:    R-jpeg
BuildRequires:    R-knitr
BuildRequires:    R-rmarkdown
BuildRequires:    R-RColorBrewer
BuildRequires:    R-rcartocolor
BuildRequires:    R-scico
BuildRequires:    R-viridis
BuildRequires:    R-wesanderson
%endif
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Carries out mapping between assorted color spaces including RGB, HSV, HLS,
CIEXYZ, CIELUV, HCL (polar CIELUV), CIELAB, and polar CIELAB. Qualitative,
sequential, and diverging color palettes based on HCL colors are provided along
with corresponding ggplot2 color scales. Color palette choice is aided by an
interactive app (with either a Tcl/Tk or a shiny graphical user interface) and
shiny apps with an HCL color picker and a color vision deficiency emulator.
Plotting functions for displaying and assessing palettes include color
swatches, visualizations of the HCL space, and trajectories in HCL and/or RGB
spectrum. Color manipulation functions include: desaturation,
lightening/darkening, mixing, and simulation of color vision deficiencies
(deutanomaly, protanomaly, tritanomaly). Details can be found on the project
web page at <http://colorspace.R-Forge.R-project.org/> and in the accompanying
scientific paper: Zeileis et al. (2020, Journal of Statistical Software,
<doi:10.18637/jss.v096.i01>).


%prep
%setup -q -c -n %{packname}


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%if %{with_suggests}
%{_bindir}/R CMD check %{packname}
%else
_R_CHECK_FORCE_SUGGESTS_=0 %{_bindir}/R CMD check %{packname} --ignore-vignettes --no-examples
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/doc
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS.md
%doc %{rlibdir}/%{packname}/CITATION
%{rlibdir}/%{packname}/LICENSE
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%{rlibdir}/%{packname}/cvdemulator
%{rlibdir}/%{packname}/data
%{rlibdir}/%{packname}/demo
%{rlibdir}/%{packname}/hclcolorpicker
%{rlibdir}/%{packname}/hclwizard
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so


%changelog
