Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(MusicBrainz/DiscID.pm) perl(Pod/Usage.pm) perl(WebService/MusicBrainz.pm) rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           abcde
Version:        2.9.3
Release:        alt2_8
Summary:        A Better CD Encoder

# cddb-tool is Public Domain, otherwise GPLv2+
License:        GPLv2+ and Public Domain
URL:            https://abcde.einval.com/
Source0:        https://abcde.einval.com/download/%{name}-%{version}.tar.gz
Source1:        https://abcde.einval.com/download/%{name}-%{version}.tar.gz.sign
# gpg2 --recv-key 0x587979573442684E
# gpg2 --export --export-options export-minimal 0x587979573442684E > 587979573442684E.gpg
Source2:        587979573442684E.gpg
Patch0:         %{name}-normalize.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=1916974
Patch1:         https://bugzilla.redhat.com/attachment.cgi?id=1748056#/abcde-gnudb.patch

BuildArch:      noarch
BuildRequires:  %{_bindir}/gpgv2
BuildRequires:  rpm-build-perl
Requires:       cd-discid
Requires:       /bin/hostname
Requires:       wget
Requires:       which
# cdparanoia, vorbis-tools for defaults
Requires:       cdparanoia
Requires:       vorbis-tools
# icedax for cd-text
Requires:     icedax
Requires:     flac
Requires:       cd-discid
Requires:       cdrdao
Requires:       ImageMagick-tools
Requires:       lame
Requires:       libcdio-paranoia
Requires:       normalize
Requires:       opus-tools
Requires:       speex
Requires:       twolame
Requires:       libwavpack wavpack
Requires:       vorbisgain
# eyeD3 is smaller than id3v2
Requires:       %{_bindir}/eyeD3
Conflicts:      eyeD3 < 0.7.0
Source44: import.info
AutoReq: yes,noshell

%description
abcde is a front end command line utility (actually, a shell script)
that grabs audio tracks off a CD, encodes them to various formats, and
tags them, all in one go.


%prep
%setup -q
%patch0 -p1
%patch1

mv examples/cue2discid .
sed -i -e 's|bin/python\b|bin/python3|' cue2discid
chmod -c -x examples/musicbrainz-get-tracks


%build


%install
%makeinstall_std prefix=%{_prefix} sysconfdir=%{_sysconfdir}
rm -r $RPM_BUILD_ROOT%{_datadir}/doc/%{name}-%{version} # handled separately
install -pm 755 cue2discid $RPM_BUILD_ROOT%{_bindir}


%files
%doc --no-dereference COPYING
%doc FAQ README changelog examples/
%config(noreplace) %{_sysconfdir}/abcde.conf
%{_bindir}/abcde
%{_bindir}/abcde-musicbrainz-tool
%{_bindir}/cddb-tool
%{_bindir}/cue2discid
%{_mandir}/man1/abcde.1*
%{_mandir}/man1/cddb-tool.1*


%changelog
