# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ pkgconfig(libusb-1.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name airspy
%define major	0
%define libname lib%{name}%{major}
%define devname lib%{name}-devel

Name:		airspy
Summary:	An advanced Software Defined Radio project
Version:	1.0.10
Release:	alt1_2
# License for tools is GPL, libraries are MIT/BSD
License:	GPLv2+ and MIT and BSD
Group:		Communications
URL:		http://airspy.com/
Source0:	https://github.com/%{name}/host/archive/v%{version}/host-%{version}.tar.gz
Patch:		airspy-1.0.8-mga-udev.rules.patch
BuildRequires:	cmake
BuildRequires:	pkgconfig(libusb)
Source44: import.info

%description
Host software for AirSpy, a project to produce a low cost, open source software
radio platform.

%package -n %{libname}
Group: Communications
Summary:	Library files for airspy
Requires:	%{name} = %{version}-%{release} 

%description -n %{libname}
Host software for AirSpy, a project to produce a low cost, open source software
radio platform. This package provides the dynamic library files.

%package -n %{devname}
Group: Communications
Summary:	Development files for airspy
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}

%description -n %{devname}
Host software for AirSpy, a project to produce a low cost, open source software
radio platform. This package provides development files.

%prep
%setup -q -n airspyone_host-%{version}
%patch0 -p1


%build
%{mageia_cmake} -DINSTALL_UDEV_RULES=ON
%mageia_cmake_build

%install
%mageia_cmake_install

mkdir -p %{buildroot}%{_udevrulesdir}
mv %{buildroot}%{_sysconfdir}/udev/rules.d/52-%{name}.rules %{buildroot}%{_udevrulesdir}/52-%{name}.rules

find %{buildroot} -name "*.a" -delete

%files
%{_udevrulesdir}/52-%{name}.rules
%{_bindir}/%{name}_*

%files -n %{libname}
%{_libdir}/lib%{name}.so.%{major}
%{_libdir}/lib%{name}.so.%{version}

%files -n %{devname}
%{_libdir}/pkgconfig/lib%{name}.pc
%{_libdir}/lib%{name}.so
%{_includedir}/lib%{name}/*.h


%changelog
