Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: perl(RRDs.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _hardened_build 1
%global clientversion 3.0.8.2
Name: argus
Version: 3.0.8.2
Release: alt2_28
Summary: Network transaction audit tool
License: GPL-2.0-or-later
Url: http://qosient.com/argus
Source0: http://qosient.com/argus/src/%{name}-%{version}.tar.gz
Source1: http://qosient.com/argus/src/%{name}-clients-%{clientversion}.tar.gz
Source2: argus.service
Source3: README.fedora
Source4: argus.logrotate
Patch0: argus-tirpc.patch
Patch1: common.patch
Patch2: argus-configure-c99.patch
Requires: logrotate
BuildRequires: gcc autoconf automake
BuildRequires: libsasl2-devel rpm-build-perl flex bison libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires: libpcap-devel zlib-devel libtirpc-devel libreadline-devel
Source44: import.info

%package clients
Group: Networking/WWW
Summary: Client tools for argus network audit

%description
Argus (Audit Record Generation and Utilization System) is an IP network
transaction audit tool. The data generated by argus can be used for a
wide range of tasks such as network operations, security and performance
management.

%description clients
Clients to the argus probe which process and display information.

%package devel
Group: Networking/WWW
Summary: Header files for argus network audit

%description devel
Header files for argus.


%prep
%setup -a0 -q
%setup -a1 -q
%patch0  -p0
%patch1  -p0
%patch2  -p1
pushd %{name}-clients-%{clientversion}
%patch2  -p1
popd
install -p -m 0644 %{SOURCE3} .

%build
autoreconf -if
export CPPFLAGS="$CPPFLAGS -I/usr/include/tirpc -fcommon"
export CXXFLAGS="$CXXFLAGS -fcommon"
%configure --with-sasl=yes --prefix=%{_prefix}
find . -type f -name 'Makefile' | xargs sed -i s/fcf-protection/fcf-protection\ -fcommon/g
pushd %{name}-clients-%{clientversion}
%configure --with-sasl=yes --prefix=%{_prefix}
make %{?_smp_mflags}
popd

%install
make DESTDIR=%{buildroot} install
pushd %{name}-clients-%{clientversion}
make DESTDIR=%{buildroot} install
# avoid unwanted dependencies when using these as docs (clients package):
find support -type f -exec chmod a-x '{}' \;
popd
rm -rf %{buildroot}/%{_libdir}
install -d -m 0755 %{buildroot}/%{_localstatedir}/lib/argus/archive
install -D -m 0644 support/Config/argus.conf %{buildroot}/%{_sysconfdir}/argus.conf
install -D -m 0644 %{SOURCE2} %{buildroot}/%{_unitdir}/argus.service
# fix up argus.conf to a good default
sed -i 's|var/log/argus|var/lib/argus|' %{buildroot}/%{_sysconfdir}/argus.conf
sed -i 's|#ARGUS_BIND_IP|ARGUS_BIND_IP|' %{buildroot}/%{_sysconfdir}/argus.conf
sed -i 's|#ARGUS_ACCESS_PORT|ARGUS_ACCESS_PORT|' %{buildroot}/%{_sysconfdir}/argus.conf
# avoid unwanted dependencies when using these as docs (main package):
find support -type f -exec chmod a-x '{}' \;

rm -rf %{buildroot}/usr/share/doc/argus-clients-3.0/
mv %{buildroot}/usr/argus %{buildroot}%{_datadir}/argus

mkdir -p %{buildroot}%{_sysconfdir}/logrotate.d
install -p -D -m 644 %{SOURCE4} %{buildroot}%{_sysconfdir}/logrotate.d/argus

%post
%post_service argus

%preun
%preun_service argus

%files
%doc support bin/argusbug
%doc CREDITS INSTALL README VERSION
%doc --no-dereference COPYING
%config(noreplace) %{_sysconfdir}/argus.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/argus
%{_unitdir}/argus.service
%{_bindir}/argus*
%{_sbindir}/argus
%{_mandir}/man5/argus*
%{_mandir}/man8/argus*
%dir %{_localstatedir}/lib/argus
%dir %{_localstatedir}/lib/argus/archive

%files clients
%doc %{name}-clients-%{clientversion}/ChangeLog %{name}-clients-%{clientversion}/COPYING
%doc %{name}-clients-%{clientversion}/CREDITS %{name}-clients-%{clientversion}/INSTALL
%doc %{name}-clients-%{clientversion}/README %{name}-clients-%{clientversion}/VERSION
%doc %{name}-clients-%{clientversion}/support
%doc README.fedora
%{_bindir}/ra*
%{_sbindir}/ra*
%{_mandir}/man1/ra*
%{_mandir}/man5/ra*
%{_mandir}/man8/ra*
%{_datadir}/argus/

%files devel
%{_includedir}/argus/

%changelog
