%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: System/Libraries
BuildRequires: /usr/bin/tic
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: A terminal program for displaying Unicode on the console
Name: bogl
Version: 0.1.18
Release: alt2_56
URL: http://packages.debian.org/unstable/source/bogl
Source0: http://update2.intellique.com/repository/archive/pool/main/b/bogl/bogl_0.1.18-1.5.tar.gz
Source1: 14x14cjk.bdf.gz
Patch0: bogl-0.1.18-1.1.sigchld.patch
Patch1: bogl-0.1.18-1.2.reduce-font.patch
Patch2: bogl-0.1.18-1.2.gzip-fonts.patch
Patch3: bogl-0.1.18-1.2.term.patch
Patch4: bogl-0.1.18-1.5.rh.patch
Patch5: bogl-0.1.9-2.6fbdev.patch
Patch6: bogl-0.1.18-noexecstack.patch
Patch7: bogl-0.1.18-format-security.patch
Patch8: bogl-0.1.18-fix-multiple-definition.patch
Patch9: bogl-0.1.18-gcc15-fixes.patch
Epoch: 0
License: GPL-2.0-or-later
BuildRequires: gcc
BuildRequires: libgd3-devel
BuildRequires: libpng-devel libpng17-tools
BuildRequires: termutils termutils-devel
Source44: import.info

%description
BOGL stands for Ben's Own Graphics Library.  It is a small graphics
library for Linux kernel frame buffers.  It supports only very simple
graphics.

%package devel
Group: Development/Other
Summary: Development files required to build BOGL applications
Requires: bogl = %{epoch}:%{version}-%{release}

%description devel
The bogl-devel package contains the static libraries and header files
for writing BOGL applications.

%package bterm
Group: System/Base
Summary: A Unicode capable terminal program for the Linux frame buffer
# Only for /usr/share/terminfo/b
Requires: libncurses

%description bterm
The bterm application is a terminal emulator that displays to a Linux
frame buffer.  It is able to display Unicode text on the console.

%prep
%setup -q -n bogl-0.1.18
%patch0  -p1 -b .sigchld
%patch1  -p1 -b .reduce-font
%patch2  -p1 -b .gzip-fonts
%patch3  -p1 -b .term
%patch4  -p1 -b .rh
%patch5  -p1 -b .26fbdev
%patch6  -p1 -b .noexecstack
%patch7  -p1 -b .format-security
%patch8  -p1 -b .fix-multiple-definition
%patch9  -p1 -b .gcc15-fixes

%build
%make_build CFLAGS="$RPM_OPT_FLAGS"
gunzip -c %{SOURCE1} > font.bdf
./bdftobogl -b font.bdf > font.bgf

%install
make CFLAGS="$RPM_OPT_FLAGS" DESTDIR=$RPM_BUILD_ROOT libdir=%{_libdir} install
mkdir -p $RPM_BUILD_ROOT/usr/share/bogl/
cp font.bgf $RPM_BUILD_ROOT/usr/share/bogl/
gzip -9 $RPM_BUILD_ROOT/usr/share/bogl/font.bgf
# remove /usr/share/terminfo/b/bterm - shipped in ncurses-base
rm $RPM_BUILD_ROOT/%{_datadir}/terminfo/b/bterm



%files
%doc ChangeLog README debian/copyright
%{_libdir}/*.so.*

%files devel
%{_bindir}/bdftobogl
%{_bindir}/mergebdf
%{_bindir}/pngtobogl
%{_bindir}/reduce-font
%exclude %{_libdir}/*.a
%{_libdir}/*.so
%{_includedir}/bogl

%files bterm
%doc README.BOGL-bterm debian/copyright
%{_bindir}/bterm
/usr/share/bogl

%changelog
