Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           cddlib
Version:        094i
Release:        alt1_2
Summary:        A library for generating all vertices in convex polyhedrons
License:        GPLv2+
URL:            https://www.inf.ethz.ch/personal/fukudak/cdd_home/
Source0:        ftp://ftp.math.ethz.ch/users/fukudak/cdd/%{name}-%{version}.tar.gz
# Extracted from http://www.sagemath.org/packages/standard/cddlib-094f.p11.spkg
Source1:        cdd_both_reps.c
# Patch from sagemath to build and test cdd_both_reps
Patch0:         %{name}-sagemath.patch

BuildRequires:  gcc
BuildRequires:  libgmp-devel libgmpxx-devel
BuildRequires:  libtool
BuildRequires:  tex(latex)
Source44: import.info

%description
The C-library cddlib is a C implementation of the Double Description 
Method of Motzkin et al. for generating all vertices (i.e. extreme points)
and extreme rays of a general convex polyhedron in R^d given by a system 
of linear inequalities:

   P = { x=(x1, ..., xd)^T :  b - A  x  >= 0 }

where A is a given m x d real matrix, b is a given m-vector 
and 0 is the m-vector of all zeros.

The program can be used for the reverse operation (i.e. convex hull
computation). This means that one can move back and forth between 
an inequality representation and a generator (i.e. vertex and ray) 
representation of a polyhedron with cdd. Also, cdd can solve a linear
programming problem, i.e. a problem of maximizing and minimizing 
a linear function over P.


%package devel
Group: Development/C
Summary:        Headers for cddlib
Requires:       %{name} = %{version}-%{release}

%description devel
Include files for cddlib.


%package static
Group: Development/C
Summary:        Static libraries for cddlib

%description static
Static libraries for cddlib.


%package tools
Group: Engineering
Summary:        Sample binaries that use cddlib
Requires:       %{name} = %{version}-%{release}

%description tools
Sample binaries that use cddlib.


%prep
%setup -q
%patch0 -p1

# Regenerate Makefile.in files due to patched Makefile.am files
autoreconf -ifs

# Install sagemath extra source
cp -p %{SOURCE1} src
ln -sf ../src/cdd_both_reps.c src-gmp/cdd_both_reps.c

# Clean up the examples
rm -rf src/~ src-gmp/~
find . -name .DS_Store\* -exec rm -f {} \+
rm doc/cddlibman.{aux,blg,dvi,log,pdf,ps}

# Fix the FSF's address
for f in `find . -type f -print0 | xargs -0 grep -Fl '675 Mass'`; do
  sed -i.orig \
    's/675 Mass Ave, Cambridge, MA 02139/51 Franklin Street, Suite 500, Boston, MA  02110-1335/' \
    $f
  touch -r $f.orig $f
  rm -f $f.orig
done

# The 094h release shipped with some debug flags accidentally left on
for fil in lib-src/cddlp.c lib-src-gmp/cddlp.c lib-src-gmp/cddlp_f.c; do
  sed -ri.orig 's/(localdebug=ddf?_)TRUE/\1FALSE/g' $fil
  touch -r ${fil}.orig $fil
  rm -f ${fil}.orig
done


%build
%configure

# Get rid of undesirable hardcoded rpaths
sed -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
    -e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' \
    -i libtool

# Configure finds libgmp and tries to link it with everything.
sed -i 's/ -lgmp//' lib-src/Makefile

%make_build
cd doc
pdflatex cddlibman.tex
pdflatex cddlibman.tex


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
mkdir $RPM_BUILD_ROOT%{_includedir}/cddlib
mv $RPM_BUILD_ROOT%{_includedir}/{cdd,cdd_f,cddmp,cddmp_f,cddtypes,cddtypes_f,setoper}.h \
  $RPM_BUILD_ROOT%{_includedir}/cddlib/
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la





%files
%doc AUTHORS ChangeLog README
%doc --no-dereference COPYING
%{_libdir}/*.so.*


%files devel
%doc doc/cddlibman.pdf examples*
%{_includedir}/cddlib
%{_libdir}/*.so


%files static
%{_libdir}/libcdd.a
%{_libdir}/libcddgmp.a


%files tools
%{_bindir}/*


%changelog
