Group: Databases
# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
%define rhel 5
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?luaver: %global luaver %(lua -e "print(string.sub(_VERSION, 5))")}
%global	luapkgdir %{_datadir}/lua/%{luaver}

Name:		datalog
Version:	2.6
Release:	alt2_18

Source0:	http://downloads.sourceforge.net/datalog/%{name}-%{version}.tar.gz

URL:		http://sourceforge.net/projects/datalog

Summary:	A Lightweight Deductive Database using Datalog
License:	LGPLv2+
%if 0%{?rhel}
%endif

BuildRequires:	gcc, makeinfo, lua-devel > 5.1, readline-devel
Source44: import.info

%description
This package contains a lightweight deductive database system.
Queries and database updates are expressed using Datalog--a
declarative logic language in which each formula is a function-free
Horn clause, and every variable in the head of a clause must appear in
the body of the clause.  The use of Datalog syntax and an
implementation based on tabling intermediate results, ensures that all
queries terminate.

The components in this package are designed to be small, and usable on
memory constrained devices.  The package includes an interactive
interpreter for Datalog, and the development package has a library
that can be used to embed the interpreter into C programs.

%package devel
Group: Development/Other
Summary: Datalog header file and library
%if 0%{?rhel}
%endif
Requires: datalog = %{version}

%description devel
This package includes the header file and library that can be used to
embed a datalog interpreter into C programs.

%prep
%setup -q

%build
%configure --with-lua --enable-shared --disable-static
%make_build

%install
make DESTDIR=%{buildroot} install
mkdir -p %{buildroot}%{luapkgdir}
install -m 644 %{name}.lua %{buildroot}%{luapkgdir}
rm -rf %{buildroot}/%{_libdir}/lib%{name}.la
rm -rf %{buildroot}/%{_datadir}/%{name}
rm -rf %{buildroot}/%{_infodir}/dir



%files
%doc %{name}.html ChangeLog README COPYING.LIB AUTHORS NEWS
%{_bindir}/%{name}
%{_libdir}/lib%{name}.so.*
%{_infodir}/%{name}.info.*
%{_mandir}/man1/*
%{luapkgdir}/%{name}.lua

%files devel
%{_includedir}/%{name}.h
%{_libdir}/lib%{name}.so

%changelog
