Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           freerouting
Version:        1.3.1
Release:        alt2_20
Summary:        Circuit Board Routing Tool

# Automatically converted from old format: GPLv3 - review is highly recommended.
License:        GPL-3.0-only
URL:            http://www.freerouting.org/
Source0:        https://freerouting.org/freerouting/changelog/freeRouting-%{version}.tar.gz
Source1:        freerouting.xml
Source2:        freerouting.desktop
Source3:        freerouting.svg
Source4:        freerouting.appdata.xml

BuildArch:      noarch

BuildRequires:  java-devel >= 1.8
BuildRequires:  jpackage-utils
BuildRequires:  desktop-file-utils
BuildRequires:  libappstream-glib libappstream-glib-gir

Requires:       java >= 1.8
Requires:       jpackage-utils
Source44: import.info


%description
FreeRouting is a routing software intended but not limited for Printed Circuit
Boards (PCB). By using the standard Specctra or Electra DSN interface it
works together with numerous CAD tools including the LayoutEditor, KiCad
and Eagle. It imports DSN-files generated by the Specctra interface and
exports Specctra session files. FreeRouting was developed in 2004 by Alfons
Wirtz. He stopped the development in 2008 and published the source code
under the GPL in 2014. From 2015 FreeRouting is included in the LayoutEditor
packages and its source code is maintained by its team.


%prep
%setup -q -n freeRouting


%build
find -name '*.java' | \
    xargs javac -encoding ISO-8859-1 -Xlint:unchecked -Xlint:deprecation
find -name '*.class' -o -wholename '*/resources/*' | \
    xargs jar cf %{name}.jar


%install
# install mimeinfo
install -p -m 0644 -D %{SOURCE1} %{buildroot}%{_datadir}/mime/packages/%{name}.xml

# install .desktop and icon files
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{SOURCE2}
install -p -m 0644 -D %{SOURCE3} %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg

# install .jar file
install -p -m 0644 -D %{name}.jar %{buildroot}%{_javadir}/%{name}.jar

# install wrapper script
%jpackage_script gui.MainApplication "" "" freerouting freerouting true

# install and AppStream metadata
install -p -m 0644 -D %{SOURCE4} %{buildroot}%{_datadir}/metainfo/%{name}.appdata.xml
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/%{name}.appdata.xml

%files
%doc --no-dereference LICENSE
%doc README.md
%{_javadir}/%{name}.jar
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/metainfo/%{name}.appdata.xml


%changelog
