Group: Other
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global plugin exploitable
%global snapshot 20210920gitab64075
%global gdb_data /usr/share/gdb/python/%{plugin}
%global gdb_init /etc/gdbinit.d

# The tarball is created like this:
# git clone https://github.com/jfoote/exploitable.git
# tar --exclude=.* -cvf exploitable.tar exploitable/*
# gzip --best exploitable.tar
# Then the snapshot global is updated to meet fedora guidelines

Name: gdb-%{plugin}
Version: 1.32
Release: alt2_22.%{snapshot}
Summary: GDB extension for exploitability
License: MIT AND MIT-CMU AND BSD-3-Clause
URL: https://github.com/jfoote/exploitable
Source0: %{plugin}.tar.gz
Source1: %{name}.gdb
Source2: README.fedora
Patch1: exploitable-distutils.patch
%if 0%{?fedora}
ExclusiveArch: x86_64 i386
%else
# Epel does not have i386 targets
ExclusiveArch: x86_64 noarch
%endif
BuildArch: noarch
Requires: gdb
Source44: import.info

%description
'exploitable' is a GDB extension that classifies Linux application bugs
by severity. The extension inspects the state of a Linux application that
has crashed and outputs a summary of how difficult it might be for an
attacker to exploit the underlying software bug to gain control of the
system. The extension can be used to prioritize bugs for software developers
so that they can address the most severe ones first.

%prep
%setup -q -n %{plugin}
%patch1  -p1

%build

%install
mkdir -p %{buildroot}%{gdb_data}
cp -ra exploitable/* %{buildroot}%{gdb_data}
rm -rf %{buildroot}%{gdb_data}/tests
mkdir -p %{buildroot}%{gdb_init}
cp %{SOURCE1} %{buildroot}%{gdb_init}
cp %{SOURCE2} .

%files
%doc README.md AUTHORS.txt README.fedora
%doc --no-dereference LICENSE.md
%dir %{gdb_data}
%{gdb_data}/*
%config(noreplace) %{gdb_init}/*

%changelog
