Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-macros-fedora-compat
BuildRequires: perl(Globus/Core/Config.pm) perl(Globus/Core/Paths.pm) perl(Globus/GRAM/Error.pm) perl(Globus/GRAM/JobManager.pm) perl(Globus/GRAM/JobState.pm) perl(Globus/GRAM/StdioMerger.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %{perl_vendor_privlib}/Globus/GRAM/JobManager/*.pm
BuildRequires: globus-gram-job-manager
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:		globus-gram-job-manager-fork
%global _name %(tr - _ <<< %{name})
Version:	3.3
Release:	alt1_11
Summary:	Grid Community Toolkit - Fork Job Manager Support

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README
#		https://github.com/gridcf/gct/pull/223
Patch0:		0001-Handle-64-bit-time_t-on-32-bit-systems.patch

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-xio-devel >= 3
BuildRequires:	globus-scheduler-event-generator-devel >= 4
BuildRequires:	globus-gram-protocol-devel >= 11
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
%if %{use_systemd}
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
%endif

#		A requirement on globus-gram-job-manager would make sense.
#		However, that would create a circular build dependency when
#		building the globus-gram-job-manager package, since the test
#		suite for that package requires globus-gram-job-manager-fork
#		to run.
# Requires:	globus-gram-job-manager >= 13
Requires:	globus-gram-job-manager-scripts >= 4
Requires:	globus-gass-cache-program >= 5
Requires:	globus-gatekeeper >= 9
Requires:	%{name}-setup = %{version}-%{release}
Source44: import.info

%package setup-poll
Group: Networking/WWW
Summary:	Grid Community Toolkit - Fork Job Manager Support using polling
BuildArch:	noarch
Provides:	%{name}-setup = %{version}-%{release}
Requires:	%{name} = %{version}-%{release}

Requires(preun):	globus-gram-job-manager-scripts >= 4

%package setup-seg
Group: Networking/WWW
Summary:	Grid Community Toolkit - Fork Job Manager Support using SEG
Provides:	%{name}-setup = %{version}-%{release}
Requires:	%{name} = %{version}-%{release}
Requires:	globus-scheduler-event-generator-progs >= 4

Requires(preun):	globus-gram-job-manager-scripts >= 4
Requires(preun):	globus-scheduler-event-generator-progs >= 4
Requires(postun):	globus-scheduler-event-generator-progs >= 4
%if %{use_systemd}
%{?systemd_requires}
%else
%endif

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Fork Job Manager Support

%description setup-poll
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-setup-poll package contains:
Fork Job Manager Support using polling to monitor job state

%description setup-seg
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-setup-seg package contains:
Fork Job Manager Support using the scheduler event generator to monitor job
state

%prep
%setup -q -n %{_name}-%{version}
%patch0  -p6

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

export MPIEXEC=no
export MPIRUN=no
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-perlmoduledir=%{perl_vendor_privlib} \
	   --with-globus-state-dir=%{_localstatedir}/log/globus

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Remove jobmanager-fork from install dir - leave it for admin configuration
rm %{buildroot}%{_sysconfdir}/grid-services/jobmanager-fork

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%preun setup-poll
if [ $1 -eq 0 ]; then
    globus-gatekeeper-admin -d jobmanager-fork-poll > /dev/null 2>&1 || :
fi

%preun setup-seg
if [ $1 -eq 0 ]; then
    globus-gatekeeper-admin -d jobmanager-fork-seg > /dev/null 2>&1 || :
%if %{use_systemd}
    systemctl --no-reload disable globus-scheduler-event-generator@fork > /dev/null 2>&1 || :
    systemctl stop globus-scheduler-event-generator@fork > /dev/null 2>&1 || :
%else
    /sbin/service globus-scheduler-event-generator stop fork > /dev/null 2>&1 || :
%endif
    globus-scheduler-event-generator-admin -d fork > /dev/null 2>&1 || :
fi

: setup-seg

%postun setup-seg
%{?ldconfig}
if [ $1 -ge 1 ]; then
%if %{use_systemd}
    systemctl try-restart globus-scheduler-event-generator@fork > /dev/null 2>&1 || :
%else
    /sbin/service globus-scheduler-event-generator condrestart fork > /dev/null 2>&1 || :
%endif
fi

%files
%dir %{perl_vendor_privlib}/Globus
%dir %{perl_vendor_privlib}/Globus/GRAM
%dir %{perl_vendor_privlib}/Globus/GRAM/JobManager
%{perl_vendor_privlib}/Globus/GRAM/JobManager/fork.pm
%dir %{_sysconfdir}/globus
%config(noreplace) %{_sysconfdir}/globus/globus-fork.conf
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files setup-poll
%config(noreplace) %{_sysconfdir}/grid-services/available/jobmanager-fork-poll

%files setup-seg
# This is a loadable module (plugin)
%{_libdir}/libglobus_seg_fork.so
%{_sbindir}/globus-fork-starter
%doc %{_mandir}/man8/globus-fork-starter.8*
%config(noreplace) %{_sysconfdir}/grid-services/available/jobmanager-fork-seg
%config(noreplace) %{_sysconfdir}/globus/scheduler-event-generator/available/fork

%changelog
