Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate boost-program_options-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          glogg
Version:       1.1.4
Release:       alt7_28
Summary:       Smart interactive log explorer
License:       GPLv3+
URL:           http://glogg.bonnefon.org
Source:        http://glogg.bonnefon.org/files/%{name}-%{version}.tar.gz
# We're using python-markdown2
# thus we need to rename markdown -> markdown2
Patch0:        %{name}-python-markdown.patch
# Look for Qt5DBus rather than QtDBus
Patch1:        %{name}-qt5dbus.patch

BuildRequires:  gcc-c++
BuildRequires:  boost-complete
BuildRequires:  desktop-file-utils
BuildRequires:  icon-theme-hicolor
BuildRequires:  python3-module-markdown2
BuildRequires:  qt5-base-devel
Source44: import.info


%description
%{name} is a multi-platform GUI application to browse and search through
long or complex log files. It is designed with programmers and system
administrators in mind. %{name} can be seen as a graphical, interactive
combination of grep and less.


%prep
%setup -q
%patch0 -p1
%patch1 -p1



%build
%qmake_qt5
make %{?_smp_flags}


%install
make INSTALL_ROOT=%{buildroot}%{_prefix} install
rm -rf %{buildroot}%{_datadir}/doc
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop

%files
%doc COPYING README.md TODO doc/documentation.html
%{_bindir}/%{name}
%{_datadir}/icons/hicolor/16x16/apps/%{name}.png
%{_datadir}/icons/hicolor/32x32/apps/%{name}.png
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_datadir}/applications/%{name}.desktop


%changelog
