# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		gpscorrelate
Summary:	GPS photo tagging application 
Version:	2.3
Release:	alt1_3
License:	GPLv2+
Group:		Graphics
URL:		https://dfandrich.github.io/gpscorrelate/
Source0:	https://github.com/dfandrich/gpscorrelate/releases/download/%{version}/%{name}-%{version}.tar.xz
BuildRequires:	exiv2
BuildRequires:	pkgconfig(exiv2)
BuildRequires:	pkgconfig(gtk+-3.0)
BuildRequires:	pkgconfig(libxml-2.0)
Source44: import.info

%description
This program correlates digital camera photos with GPS data in GPX format. The
result is images with the location they were taken embedded in the photo's EXIF
data.

%prep
%setup -q


%build
%make_build LDFLAGS="%{?ldflags}" CFLAGS="%{optflags} -DENABLE_NLS" prefix=%{_prefix}
%make_build build-po prefix=%{_prefix}

%check
%make_build check

%install
%make_install DESTDIR=%buildroot install install install-po prefix=%{_prefix}
install -D -m 644 gpscorrelate-gui.svg %{buildroot}%{_iconsdir}/hicolor/scalable/apps/gpscorrelate-gui.svg
install -D -m 644 gpscorrelate.desktop %{buildroot}%{_datadir}/applications/gpscorrelate.desktop
install -D -m 644 io.github.dfandrich.gpscorrelate.metainfo.xml %{buildroot}%{_metainfodir}/io.github.dfandrich.gpscorrelate.metainfo.xml
%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS RELEASES doc
%doc %{_docdir}/%{name}/*
%doc --no-dereference COPYING
%{_bindir}/*
%{_mandir}/*/*
%{_datadir}/applications/*
%{_metainfodir}/io.github.dfandrich.gpscorrelate.metainfo.xml
%{_iconsdir}/hicolor/scalable/apps/*


%changelog
