Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Review request: https://bugzilla.redhat.com/show_bug.cgi?id=1028743

Name:             hans
Version:          1.0
Release:          alt2_14
Summary:          IP over ICMP tunneling solution

License:          GPLv3+
URL:              http://code.gerade.org/hans/
Source0:          https://github.com/friedrich/%{name}/archive/v%{version}.tar.gz#/hans-%{version}.tar.gz
# My systemd and preconfiguration stuff
Source1:          %{name}-client.service
Source2:          %{name}-server.service
Source3:          %{name}-client.sysconfig
Source4:          %{name}-server.sysconfig
Requires(pre):    shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
# By default requires both client and server for easy installation. But you may install only server or client if desired
Requires:         %{name}-server, %{name}-client
Source44: import.info

%description
Hans makes it possible to tunnel IPv4 through ICMP echo packets, so you could
call it a ping tunnel. This can be useful when you find yourself in the
situation that your Internet access is firewalled, but pings are allowed.

Hans runs on Linux as a client and a server. It runs on Mac OS X,
iPhone/iPod touch, FreeBSD and OpenBSD as a client only.

You probably want also install packages %{name}-client or %{name}-server or both

%package client
Group: Other
Summary:          Client part of solution to tunnel IPv4 data through a ICMP
BuildRequires:  gcc-c++
BuildRequires:  gcc
BuildRequires:    libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Requires:         %{name} = %{version}-%{release}

%description client
This is the client part of %{name} solution.

%package server
Group: Other
Summary:          Server part of solution to tunnel IPv4 data through a ICMP
BuildRequires:    libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Requires:         %{name} = %{version}-%{release}

%description server
This is the server part of %{name} solution.

%prep
%setup -q

%build
# no configure scripts
%make_build FLAGS="%{optflags}"

%install
install -pD %{name} %{buildroot}/%{_sbindir}/%{name}

install -Dp -m 0644 %{SOURCE1} %{buildroot}/%{_unitdir}/%{name}-client.service
install -Dp -m 0644 %{SOURCE2} %{buildroot}/%{_unitdir}/%{name}-server.service

install -Dp -m 0644 %{SOURCE3} %{buildroot}/%{_sysconfdir}/sysconfig/%{name}-client
install -Dp -m 0644 %{SOURCE4} %{buildroot}/%{_sysconfdir}/sysconfig/%{name}-server
sed -i s,/usr/bin/bash,/bin/bash, %{buildroot}/%{_unitdir}/%{name}-*.service

%pre
getent passwd %{name} >/dev/null || useradd -r -s /sbin/nologin -c "IP over ICMP tunneling user" %{name}

%post client
%post_service %{name}

%preun client
%preun_service %{name}

%post server
%post_service %{name}

%preun server
%preun_service %{name}

%files
%doc CHANGES README.md
%doc --no-dereference LICENSE
%{_sbindir}/%{name}

%files client
%attr(0600,hans,root) %config(noreplace) %{_sysconfdir}/sysconfig/%{name}-client
%{_unitdir}/%{name}-client.service

%files server
%attr(0600,hans,root) %config(noreplace) %{_sysconfdir}/sysconfig/%{name}-server
%{_unitdir}/%{name}-server.service

%changelog
