Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 21

%global appname com.github.danrabbit.harvey

Name:           harvey
Summary:        The hero that Gotham needs right now
Version:        1.0.2
Release:        alt1_%autorelease
# The entire source is GPL-3.0-or-later:
#
#   The COPYING file is GPLv3, and while the phrase a.'or any later versiona.' does
#   not appear, data/com.github.danrabbit.harvey.appdata.xml.in,
#   debian/copyright, and the SPDX headers of the Vala sources, src/*.vala,
#   indicate GPLv3+ is intended. For example, from the AppData file:
#
#     <project_license>GPL-3.0+</project_license>
#
# a..except:
#   - data/Application.css is GPL-2.0-or-later
#   - data/com.github.danrabbit.harvey.appdata.xml.in is CC0-1.0, which is only
#   allowed for content
License:        GPL-3.0-or-later AND GPL-2.0-or-later AND CC0-1.0

URL:            https://github.com/danrabbit/harvey
Source:         https://github.com/danrabbit/harvey/archive/%{version}/harvey-%{version}.tar.gz

# Fix deprecated top-level developer_name in AppData XML
# https://github.com/danirabbit/harvey/pull/52
Patch:          https://github.com/danrabbit/harvey/pull/52.patch

# https://fedoraproject.org/wiki/Changes/EncourageI686LeafRemoval
ExcludeArch:    %{ix86}

BuildRequires:  desktop-file-utils
BuildRequires:  gettext-tools

# Still required by guidelines for now
# (https://pagure.io/packaging-committee/issue/1053):
BuildRequires:  libappstream-glib libappstream-glib-gir
# Matches what gnome-software and others use:
BuildRequires:  appstream libappstream

BuildRequires:  hardlink

BuildRequires:  meson
BuildRequires:  vala vala-tools valadoc-devel
BuildRequires:  gcc

BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gobject-2.0)
BuildRequires:  pkgconfig(granite)
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(libhandy-1)

Requires:       icon-theme-hicolor

Summary(fr):    Le héro dont Gotham a besoin dès à présent
Summary(es):    El héroe que Gotham estaba necesitando
Summary(en_AU): The hero that Gotham needs right now
Summary(en_CA): The hero that Gotham needs right now
Summary(en_GB): The hero that Gotham needs right now
Source44: import.info

%description
Calculate and visualize color contrast. Harvey checks a given set of colors for
WCAG contrast compliance.

%description -l fr
Calculez et visualisez les contrastes de couleur. Harvey vérifie qu’un jeu de
couleur est conforme aux recommandation de contraste WCAG.

%description -l es
Calcule y visualice el contraste de color, Harvey comprueba un conjunto
determinado de colores para el cumplimiento del contraste WCAG.

%description -l en_AU
Calculate and visualise colour contrast. Harvey checks a given set of colours
for WCAG contrast compliance.

%description -l en_CA
Calculate and visualize colour contrast. Harvey checks a given set of colours
for WCAG contrast compliance.

%description -l en_GB
Calculate and visualise colour contrast. Harvey checks a given set of colours
for WCAG contrast compliance.


%prep
%setup -q
%patch0 -p1



%build
%meson
%meson_build


%install
%meson_install

%find_lang %{appname}

# Upstream installs the same SVG icon in many size-specific directories like
# /usr/share/icons/hicolor/64x64@2/; we can save space by hardlinking these
# together.
hardlink -c -v '%{buildroot}%{_datadir}/icons/hicolor'


%check
desktop-file-validate \
    %{buildroot}/%{_datadir}/applications/%{appname}.desktop

# Still required by guidelines for now
# (https://pagure.io/packaging-committee/issue/1053):
appstream-util validate-relax --nonet \
    %{buildroot}/%{_metainfodir}/%{appname}.appdata.xml
# Matches what gnome-software and others use:
appstreamcli validate --no-net --explain \
    %{buildroot}/%{_metainfodir}/%{appname}.appdata.xml


%files -f %{appname}.lang
%doc README.md
%doc --no-dereference LICENSE

%{_bindir}/%{appname}

%{_datadir}/applications/%{appname}.desktop
%{_datadir}/glib-2.0/schemas/%{appname}.gschema.xml
%{_datadir}/icons/hicolor/*/apps/%{appname}.svg
%{_metainfodir}/%{appname}.appdata.xml


%changelog
