Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate /usr/bin/sqlite3 libgio-devel pkgconfig(json-glib-1.0) pkgconfig(libsoup-3.0) pkgconfig(lua) pkgconfig(opencc)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global snapshot 0

Name:       ibus-libpinyin
Version:    1.15.4
Release:    alt1_1
Summary:    Intelligent Pinyin engine based on libpinyin for IBus
License:    GPL-3.0-or-later
URL:        https://github.com/libpinyin/ibus-libpinyin
Source0:    http://downloads.sourceforge.net/libpinyin/ibus-libpinyin/%{name}-%{version}.tar.gz
%if %snapshot
Patch0:     ibus-libpinyin-1.15.x-head.patch
%endif

Requires:       python3-module-pygobject3
Requires:       ibus python3-module-ibus-overrides
BuildRequires:  gcc-c++
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  libtool
BuildRequires:  libsqlite3-devel
BuildRequires:  libuuid-devel
BuildRequires:  lua-devel
BuildRequires:  python3-devel
BuildRequires:  desktop-file-utils
BuildRequires:  libibus-devel libibus-gir-devel
BuildRequires:  libpinyin-devel >= 2.1.0

# Requires(post): sqlite

Requires:   libpinyin-data >= 1.5.91

Obsoletes: ibus-pinyin < 1.4.0-17
Source44: import.info

%description
It includes a Chinese Pinyin input method and a Chinese ZhuYin (Bopomofo) 
input method based on libpinyin for IBus.

%prep
%setup -q
%if %snapshot
%patch0 -p1 -b .head
%endif

%build
%configure --disable-static \
           --with-python=python3 \
           --disable-boost

# make -C po update-gmo
%make_build

%check
desktop-file-validate $RPM_BUILD_ROOT%{_datadir}/applications/ibus-setup-libpinyin.desktop
desktop-file-validate $RPM_BUILD_ROOT%{_datadir}/applications/ibus-setup-libbopomofo.desktop

%install
%makeinstall_std

#py_byte_compile /usr/bin/python3 $RPM_BUILD_ROOT%{_datadir}/ibus-libpinyin/setup

%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS COPYING README
%{_datadir}/metainfo/*.appdata.xml
%{_datadir}/glib-2.0/schemas/*.gschema.xml
%{_datadir}/applications/ibus-setup-libpinyin.desktop
%{_datadir}/applications/ibus-setup-libbopomofo.desktop
%{_libexecdir}/ibus-engine-libpinyin
%{_libexecdir}/ibus-setup-libpinyin
%{_datadir}/ibus-libpinyin/icons
%{_datadir}/ibus-libpinyin/setup
%{_datadir}/ibus-libpinyin/base.lua
%{_datadir}/ibus-libpinyin/user.lua
%{_datadir}/ibus-libpinyin/network.txt
%{_datadir}/ibus-libpinyin/db/english.db
%{_datadir}/ibus-libpinyin/db/table.db
%dir %{_datadir}/ibus-libpinyin
%dir %{_datadir}/ibus-libpinyin/db
%{_datadir}/ibus/component/*

%changelog
