# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-python3
# END SourceDeps(oneline)
Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 6

Name:       imgp
Version:    2.9
Release:    alt1_%autorelease
Summary:    Multi-core batch image resizer and rotator

License:    GPL-3.0-only
URL:        https://github.com/jarun/imgp
Source0:    https://github.com/jarun/imgp/archive/v%{version}/%{name}-%{version}.tar.gz

BuildArch:  noarch


Requires:   python3-module-Pillow
Source44: import.info


%description
imgp is a command line image resizer and rotator for JPEG and PNG images. 
It can resize (or thumbnail) and rotate thousands of images in a go,
at lightning speed, while saving significantly on storage.

Powered by multiprocessing, an intelligent adaptive algorithm, 
recursive operations, shell completion scripts, EXIF preservation (and more), 
imgp is a very flexible utility with well-documented easy to use options.

imgp intends to be a stronger replacement of the Nautilus Image Converter 
extension, not tied to any file manager and way faster. On desktop environments 
(like Xfce or LxQt) which do not integrate Nautilus, imgp will save your day.

%prep
%setup -q -n %{name}-%{version}

sed -i '1s/env //' imgp


%build
# Nothing to do


%install
%makeinstall_std PREFIX=%{_prefix}
install -Dpm0644 -t %{buildroot}%{_datadir}/bash-completion/completions \
  auto-completion/bash/imgp-completion.bash
install -Dpm0644 -t %{buildroot}%{_datadir}/fish/vendor_functions.d \
  auto-completion/fish/imgp.fish
install -Dpm0644 -t %{buildroot}%{_datadir}/zsh/site-functions \
  auto-completion/zsh/_imgp


%files
%doc CHANGELOG README.md
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_datadir}/bash-completion/completions/imgp-completion.bash
%dir %{_datadir}/fish/vendor_functions.d
%{_datadir}/fish/vendor_functions.d/imgp.fish
%dir %{_datadir}/zsh/site-functions
%{_datadir}/zsh/site-functions/_imgp


%changelog
