# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 18
Name:           libkni3
Version:        3.9.2
Release:        alt1_17
Summary:        C++ KNI library v3 for the Katana 300 robot arm

Group:          System/Libraries
License:        GPLv2+
URL:            http://www.neuronics.ch/cms_de/web/index.php?id=386
Source0:        http://www.neuronics.ch/cms_de/mediabase/KNI_3.9.2.tar.gz
Patch0:         kni-3.9.2-gcc43.patch
Patch1:         kni-3.9.2-sofixes.patch
Patch2:         kni-3.9.2-ctor.patch
Patch3:         kni-3.9.2-noexit.patch
Patch4:         kni-3.9.2-gcc47.patch

BuildRequires:  doxygen graphviz
%if 0%{?fedora} >= 9
BuildRequires:  texlive-extra-utils
%else
BuildRequires:  texlive-generic-recommended
%endif

BuildRequires:  boost-devel boost-filesystem-devel boost-wave-devel boost-graph-parallel-devel boost-math-devel boost-mpi-devel boost-program_options-devel boost-signals-devel boost-intrusive-devel boost-asio-devel
Source44: import.info

%description
Katana Native Interface is a C++ library for programmers who would like to
write their own programs, but don't want to implement the protocol and
device stuff katana is using.

This package contains the library for the Katana 300 series of the arm. For
newer robots use libkni (version 4 and above).


%package        devel
Summary:        Development files for %{name}
Group:          Development/C
Requires:       %{name} = %{version}-%{release}

%description    devel
The %%{name}-devel package contains libraries and header files for
developing applications that use %%{name}.


%package        static
Summary:        Static libraries for %{name}
Group:          Development/C

%description    static
This package contains static libraries that can be used to
compile static binaries using %%{name}.


%package        doc
Summary:        Documentation for %{name}
Group:          Documentation

%description    doc
This package contains the documentation for developing with %%{name}.

%package        examples
Summary:        Example applications for %{name}
Group:          File tools
Requires:       %{name} = %{version}-%{release}

%description    examples
This package contains demo applications for %%{name}.

%prep
%setup -q -n KNI_%{version}
%patch0 -p1 -b .gcc43
%patch1 -p1 -b .sofixes
%patch2 -p1 -b .ctor
%patch3 -p1 -b .noexit
%patch4 -p1 -b .gcc47


%build
make CFLAGS="%{optflags}"
make doc
echo "prefix=%{prefix}
exec_prefix=%{prefix}
libdir=%{_libdir}
includedir=%{_includedir}

Name: %{name}
Description: %{summary}
Version: %{version}
Libs: -L\${libdir} -lKNIBase3 -lKNI_InvKin3 -lKNI_LM3
Cflags: -I\${includedir}/kni3" > libkni3.pc


%install
mkdir -p %{buildroot}
mkdir -p %{buildroot}%{_libdir}
install -m 0644 -p lib/linux/*.a %{buildroot}%{_libdir}
install -p lib/linux/*.so.* %{buildroot}%{_libdir}
for f in `find %{buildroot}%{_libdir} -name '*.so.*.*.*'`; do
    ln -s `basename $f` %{buildroot}%{_libdir}/`echo \`basename $f\` | sed -e 's/\(\(.*\).so\)\(.*\)/\1/'`
    ln -s `basename $f` %{buildroot}%{_libdir}/`objdump --private-headers $f | grep SONAME | awk '{print $2}'`
done
mkdir -p %{buildroot}%{_bindir}
for f in `find demo/ -perm /a+x -type f`; do
    install -p $f %{buildroot}%{_bindir}/kni_`basename $f`
done
mkdir -p %{buildroot}%{_sysconfdir}/kni3
mkdir -p %{buildroot}%{_sysconfdir}/kni3/hd300
mkdir -p %{buildroot}%{_sysconfdir}/kni3/hd400
install -p -m 0644 configfiles300/*.cfg %{buildroot}%{_sysconfdir}/kni3/hd300
install -p -m 0644 configfiles400/*.cfg %{buildroot}%{_sysconfdir}/kni3/hd400
mkdir -p %{buildroot}%{_includedir}/kni3
cp -a include/* %{buildroot}%{_includedir}/kni3
mkdir -p %{buildroot}%{_docdir}/%{name}-doc-%{version}
cp -a doc/html %{buildroot}%{_docdir}/%{name}-doc-%{version}
install -p -m 0644 doc/*.pdf %{buildroot}%{_docdir}/%{name}-doc-%{version}
find %{buildroot} -name '.svn' | xargs rm -rf
mkdir -p %{buildroot}%{_libdir}/pkgconfig
install -p -m 0644 libkni3.pc %{buildroot}%{_libdir}/pkgconfig


%files
%doc LICENSE.txt readme.txt AUTHORS.txt
%{_libdir}/*.so.*
%dir %{_sysconfdir}/kni3
%dir %{_sysconfdir}/kni3/hd300
%dir %{_sysconfdir}/kni3/hd400
%config(noreplace)%{_sysconfdir}/kni3/*/*.cfg

%files devel
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files static
%{_libdir}/*.a

%files doc
%{_docdir}/%{name}-doc-%{version}

%files examples
%{_bindir}/kni_*


%changelog
