Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Old version of libpng, needed to run old binaries
Name:		libpng10
Version:	1.0.69
Release:	alt1_7
License:	zlib
URL:		http://www.libpng.org/pub/png/libpng.html
Source0:	https://ftp-osl.osuosl.org/pub/libpng/src/libpng10/libpng-%{version}.tar.gz
Patch0:		libpng-1.0.63-soname.patch
Patch1:		libpng10-1.0.69-cve-2018-13785.patch
BuildRequires:	coreutils
BuildRequires:	gcc
BuildRequires:	zlib-devel
Conflicts:	libpng16 < 2:1.2.0

Source44: import.info

%description
The libpng10 package contains an old version of libpng, a library of functions
for creating and manipulating PNG (Portable Network Graphics) image format
files.

This package is needed if you want to run binaries that were linked dynamically
with libpng 1.0.x.

%package devel
Group: Development/C
Summary:	Development tools for version 1.0 of libpng
Requires:	libpng10 = %{version}-%{release}
Requires:	pkgconfig

%description devel
The libpng10-devel package contains the header files necessary for developing
programs using version 1.0 of the PNG (Portable Network Graphics) library.

If you want to develop programs that will manipulate PNG image format files,
while still running on previous old Linux releases, you should install
libpng10-devel.

%prep
%setup -q -n libpng-%{version}

# We want an soname of 2.%%{version}
%patch0 -b .soname

# Fix the calculation of row_factor in png_check_chunk_length (CVE-2018-13785)
# https://sourceforge.net/p/libpng/bugs/278/
# https://github.com/ctruta/libpng/commit/8a05766cb74af05c04c53e6c9d60c13fc4d59bf2
%patch1 -b .cve-2018-13785

%build
%configure \
	--disable-static \
	--disable-dependency-tracking \
	--without-binconfigs
%make_build

%install
make DESTDIR=%{buildroot} INSTALL="install -p" install

# Unpackaged files
rm -f \
	%{buildroot}%{_bindir}/libpng-config \
	%{buildroot}%{_includedir}/png.h \
	%{buildroot}%{_includedir}/pngconf.h \
	%{buildroot}%{_libdir}/libpng.a \
	%{buildroot}%{_libdir}/libpng.la \
	%{buildroot}%{_libdir}/libpng.so \
	%{buildroot}%{_libdir}/libpng10.la \
	%{buildroot}%{_libdir}/libpng10.so.* \
	%{buildroot}%{_libdir}/pkgconfig/libpng.pc \
	%{buildroot}%{_mandir}/man3/libpng.3 \
	%{buildroot}%{_mandir}/man3/libpngpf.3 \
	%{buildroot}%{_mandir}/man5/png.5

# Fix devel link
rm -f %{buildroot}%{_libdir}/libpng10.so
ln -s libpng.so.2 %{buildroot}%{_libdir}/libpng10.so

%if (0%{?rhel} && 0%{?rhel} <= 7) || (0%{?fedora} && 0%{?fedora} <= 27)
# ldconfig scriptlets replaced by RPM File Triggers from Fedora 28
%endif
%files
%doc ANNOUNCE
%doc CHANGES
%doc README
%doc TODO
%doc Y2KINFO
%doc --no-dereference LICENSE
%{_libdir}/libpng.so.2
%{_libdir}/libpng.so.2.%{version}

%files devel
%doc example.c
%doc libpng-%{version}.txt
%{_includedir}/libpng10/
%{_libdir}/libpng10.so
%{_libdir}/pkgconfig/libpng10.pc

%changelog
