Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       llconf
Version:    0.4.6
Release:    alt2_30
Summary:    Loss-less configuration file parser
# Automatically converted from old format: LGPLv2+ - review is highly recommended.
License:    LicenseRef-Callaway-LGPLv2+
# The code.google.com home is dead. There is
# <https://github.com/lipnitsk/llconf> but its 0.4.6 archive contains some
# additional files (e.g. src/parsers/cron.c copied into src/cron.c with
# changes license text.)
URL:        http://code.google.com/p/%{name}/
Source0:    http://%{name}.googlecode.com/files/%{name}-%{version}.tar.gz
Patch0:     llconf-0.4.6-Install-parsers-headers-into-subdirectory.patch
Patch1:     llconf-0.4.6-Unify-paths-in-examples.patch
# Fix a use-after-free in cnf_del_branch(),
# <https://github.com/lipnitsk/llconf/commit/aa33098dbe1246bc4d19843a63f25f799442f74a>
Patch2:     llconf-0.4.6-llconf-entry-fix-use-after-free-condition.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  doxygen
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  libtool
Requires:   %{name}-libs = %{version}-%{release}
Source44: import.info

%description
llconf (loss-less configuration) tool is meant as a middle ware to unify
control over configuration files. It tries to parse different
configuration files using different modules, and rewrite them after
applying changes, without destroying user changes and comments, so
that it is still possible to edit the files with a common text editor.


%package libs
Group: System/Libraries
Summary:    Loss-less configuration file parser library

%description libs
llconf (loss-less configuration) is meant as a middle ware to unify
control over configuration files. It tries to parse different
configuration files using different modules, and rewrite them after
applying changes, without destroying user changes and comments, so
that it is still possible to edit the files with a common text editor.


%package devel
Group: Development/Other
Summary:    Development files for %{name}
Requires:   %{name}-libs = %{version}-%{release}
Requires:   pkgconfig

%description devel
Libraries and header files needed for developing applications that use
%{name}.


%prep
%setup -q
%patch0  -p1
%patch1  -p1
%patch2  -p1
# Update libtool not to inject useless RPATH into resulting executable
libtoolize -fi
autoreconf -i
chmod -x examples/wizard

%build
%configure --disable-static
%make_build
make -C doc doxygen

%install
make install DESTDIR=$RPM_BUILD_ROOT
find "$RPM_BUILD_ROOT" -name '*.la' -delete




%files
%doc examples/etc examples/wizard README.llconf
%{_bindir}/*

%files libs
%doc COPYING README 
%{_libdir}/*.so.*

%files devel
%doc examples/example.c doc/html
%{_includedir}/%{name}
%{_libdir}/*.so
%{_libdir}/pkgconfig/%{name}.pc


%changelog
