# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 3.1.9
%global url_ver %(echo %{version} | cut -d. -f1,2)

%global __provides_exclude_from %{_libdir}/.*\\.so

Summary:	ODBC driver library for connecting to MariaDB and MySQL servers
Name:		mariadb-connector-odbc
Version:	3.1.9
Release:	alt1_1
Group:		Development/Databases
License:	LGPLv2+
URL:		https://mariadb.com/kb/en/library/mariadb-connector-odbc/
Source0:	https://downloads.mariadb.org/interstitial/connector-odbc-%{version}/mariadb-connector-odbc-%{version}-ga-src.tar.gz
Patch0:		libraries_include_path.patch
Patch1:		add_docs_license_dir_option
BuildRequires:	ccmake cmake ctest
BuildRequires:	libmariadb-devel
BuildRequires:	libunixODBC-devel libunixODBC-devel-compat libunixODBC2
BuildRequires:	pkgconfig(openssl)
Requires(preun):	unixODBC
Requires(post):		unixODBC
Requires:	unixODBC
Provides:	mysql-connector-odbc
Obsoletes:	mysql-connector-odbc < 5.3.2-5
Source44: import.info

%description
MariaDB Connector/ODBC is a standardized database driver using the industry
standard Open Database Connectivity (ODBC) API.

It supports ODBC Standard 3.5, can be used as a drop-in replacement for
MySQL Connector/ODBC, and it supports both Unicode and ANSI modes.

%prep
%setup -q -n %{name}-%{version}-ga-src
%patch0 -p1
%patch1 -p1


%build
export CFLAGS="%{optflags} -pthread"
%{mageia_cmake} \
	-DINSTALL_LIBDIR:STRING=%{_lib} \
	-DMARIADB_LINK_DYNAMIC:BOOL=TRUE \
	-DWITH_OPENSSL:BOOL=TRUE \
	-DINSTALL_DOCDIR="%{_defaultdocdir}/%{name}" \
	-DINSTALL_LICENSEDIR="%{_defaultlicensedir}/%{name}"

%mageia_cmake_build

%install
%mageia_cmake_install

mkdir -p %{buildroot}%{_datadir}/%{name}/
cat >> %{buildroot}%{_datadir}/%{name}/%{name}.ini << EOF
[MariaDB ODBC 3.1 Driver]
Driver = %{_libdir}/libmaodbc.so
Description = MariaDB Connector/ODBC v.3.1
EOF

rm -rf %{buildroot}%{_docdir}

%preun
if [[ $1 -eq 0 ]] ; then
  if [[ -x %{_bindir}/odbcinst ]]; then
    %{_bindir}/odbcinst -v -d -u -n 'MariaDB ODBC 3.1 Driver'
  fi
fi

%post
if [[ $1 -eq 1 ]] ; then
  if [[ -x %{_bindir}/odbcinst ]]; then
    %{_bindir}/odbcinst -v -d -i -f %{_datadir}/%{name}/%{name}.ini
  fi
fi

%triggerun -- mariadb-connector-odbc < 3.1.5
if [[ -x %{_bindir}/odbcinst ]]; then
  %{_bindir}/odbcinst -v -d -u -n 'MariaDB ODBC 3.0 Driver'
  %{_bindir}/odbcinst -v -d -i -f %{_datadir}/%{name}/%{name}.ini
fi

%files
%doc --no-dereference COPYING
%doc README
%{_libdir}/libmaodbc.so
%dir %{_datadir}/%{name}/
%{_datadir}/%{name}/%{name}.ini


%changelog
