# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/pathfix.py python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		mma
Summary:	Musical MIDI Accompaniment
Version:	21.09
Release:	alt1_1
License:	GPLv2+
Group:		Sound
Url:		http://www.mellowood.ca/mma/
Source0:	http://www.mellowood.ca/%{name}/%{name}-bin-%{version}.tar.gz
BuildArch:	noarch
BuildRequires:	pkgconfig(python3)
Source44: import.info

%description
Musical MIDI Accompaniment is an accompaniment generator -- it creates midi
tracks for a soloist to perform over from a user supplied file containing
chords and MMA directives. Is is very versatile and generates excellent
tracks. It comes with an extensive user-extendable library with a variety of
patterns for various popular rhythms, an extensive user manual, and several
demo songs. MMA is a command line driven program. It creates MIDI files which
need a sequencer or MIDI file play program.

%prep
%setup -qn %{name}-bin-%{version}
for file in `grep -r '#!/usr/bin/python'|cut -d ":" --fields=1`
do
  sed -i 's|#!/usr/bin/python|#!/usr/bin/python3|g' $file
done

for file in `grep -r '#!/usr/bin/env python'|cut -d ":" --fields=1`
do
  sed -i 's|#!/usr/bin/env python|#!/usr/bin/python3|g' $file
done



# python shebangs
pathfix.py -pni "%{__python3} " .

%build
# Nothing to do

%install
install -Dm 755 %{name}.py %{buildroot}%{_bindir}/%{name}
install -Dm 755 %{name}-gb %{buildroot}%{_bindir}/%{name}-gb
install -Dm 755 %{name}-libdoc %{buildroot}%{_bindir}/%{name}-libdoc
install -Dm 755 %{name}-renum %{buildroot}%{_bindir}/%{name}-renum
install -Dm 755 %{name}-splitrec %{buildroot}%{_bindir}/%{name}-splitrec
install -Dm 755 util/%{name}-mnx.py %{buildroot}%{_bindir}/%{name}-mnx
install -Dm 755 util/%{name}-rm2std.py %{buildroot}%{_bindir}/%{name}-rm2std
install -Dm 755 util/%{name}-splitrec.py %{buildroot}%{_bindir}/%{name}-splitrec
install -Dm 755 util/mup2%{name}.py %{buildroot}%{_bindir}/mup2%{name}
install -Dm 755 util/pg2%{name}.py %{buildroot}%{_bindir}/pg2%{name}
install -Dm 755 util/synthsplit.py %{buildroot}%{_bindir}/synthsplit
install -d m 755 %{buildroot}%{_datadir}/%{name}
install -d m 755 %{buildroot}%{_mandir}/man1
install -d m 755 %{buildroot}%{_mandir}/man8
cp -a lib includes MMA %{buildroot}%{_datadir}/%{name}
install -Dm 644 docs/man/*.1 %{buildroot}%{_mandir}/man1/
install -Dm 644 docs/man/*.8 %{buildroot}%{_mandir}/man8/

%post
%{name} -G

%files
%doc text/A* text/C* text/ENCODINGS text/F* text/R* text/S* text/T*
%doc egs util/README.* text/archive
%{_bindir}/%{name}*
%{_bindir}/mup2%{name}
%{_bindir}/pg2%{name}
%{_bindir}/synthsplit
%{_datadir}/%{name}
%{_mandir}/man?/*


%changelog
