Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install fontconfig-devel libICE-devel libSM-devel libX11-devel libXpm-devel libXrender-devel
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: A lightweight multi-tabbed terminal emulator for X
Name: mrxvt 
Version: 0.5.3
Release: alt2_37
URL: http://materm.sourceforge.net/wiki/Main/HomePage
License: GPLv2+
BuildRequires:  gcc
BuildRequires: libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel libXft-devel libXaw-devel libXext-devel desktop-file-utils
BuildRequires: libpng-devel libpng17-tools libjpeg-devel libutempter-devel 

Source0: http://downloads.sourceforge.net/materm/%{name}-%{version}.tar.gz
Source1: http://littlehat.homelinux.org:8000/FEDORA/mrxvt/current/0.5.3/%{name}.desktop

Patch1: http://downloads.sourceforge.net/materm/no-scroll-with-buffer-mrxvt-0.5.3.patch
Patch2: mrxvt-0.5.3-gcc10-fno-common.patch
# http://cvs.schmorp.de/rxvt-unicode/src/command.C?r1=1.584&r2=1.585
# https://bugzilla.redhat.com/show_bug.cgi?id=1961794
Patch3: mrxvt-0.5.3-CVE-2021-33477.patch
Source44: import.info

%description
Mrxvt (previously materm) is based on 2.7.11 CVS of rxvt and aterm.

%prep
%setup -q 
%patch1 -p0 -b .no-scroll-with-buffer-mrxvt-0.5.3
%patch2 -p1 -b .gcc10
%patch3 -p1 -b .cve-2021-33477
sed -i 's|\r||' share/scripts/mrxvt.vbs

%build
%configure \
           --enable-everything \
           --disable-debug

%make_build

%install
make DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p" install 

desktop-file-install \
%if 0%{?fedora} && 0%{?fedora} < 19
        --vendor=fedora \
%endif
        --dir=$RPM_BUILD_ROOT%{_datadir}/applications \
        %{SOURCE1}

rm -rf $RPM_BUILD_ROOT%{_datadir}/doc

%files 
%doc doc/README* doc/*.txt*
%doc share/scripts/
%doc AUTHORS ChangeLog COPYING NEWS README TODO
%{_bindir}/mrxvt
%{_mandir}/man1/mrxvt.1*
%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/mrxvt/default.menu
%config(noreplace) %{_sysconfdir}/mrxvt/mrxvtrc
%config(noreplace) %{_sysconfdir}/mrxvt/mrxvtrc.sample
%config(noreplace) %{_sysconfdir}/mrxvt/submenus.menu
%if 0%{?fedora} && 0%{?fedora} < 19
%{_datadir}/applications/fedora-mrxvt.desktop
%else
%{_datadir}/applications/mrxvt.desktop
%endif
%{_datadir}/pixmaps/%{name}*

%changelog
