Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename acorn-jsx

# Tests disabled until we can bootstrap npm(acorn)
%global enable_tests 1

Name:		nodejs-acorn-jsx
Version:	4.1.1
Release:	alt1_5
Summary:	Alternative, faster React.js JSX parser

License:	MIT
URL:		https://github.com/RReverser/acorn-jsx
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(acorn)
%if 0%{?enable_tests}
BuildRequires:	npm(mocha)
BuildRequires:	npm(chai)
%endif
Source44: import.info

%description
Alternative, faster React.js JSX parser


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package


%nodejs_fixdep acorn

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{__nodejs} test/run.js
echo -e "\e[102m -=#=- Tests passed -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
