Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 1
%global module_name ascii-tree

Name:           nodejs-%{module_name}
Version:        0.1.1
Release:        alt1_11
Summary:        A node module for generating a text tree in ASCII

License:        MIT
URL:            https://github.com/liushuping/ascii-tree
Source0:        http://registry.npmjs.org/%{module_name}/-/%{module_name}-%{version}.tgz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(freetree)
%endif
Source44: import.info

%description
Editing an ASCII tree manually is not easy, the freetree module provides an
easy way for creating in-memory tree data structure from simple bullet items.
This ascii-tree module leverages freetree and outputs formatted tree in ascii
characters.

%prep
%setup -q -n package
rm -rf node_modules

%nodejs_fixdep freetree ~0.x

sed -i "s|\r||g" README.md LICENSE

%build
# nothing to build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{module_name}
cp -pr package.json *.js %{buildroot}%{nodejs_sitelib}/%{module_name}
%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
mocha ./test/ascii-tree.test.js
%endif

%files
%doc README.md LICENSE
%{nodejs_sitelib}/%{module_name}

%changelog
