Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename babel-code-frame

# tests disabled.  They run fine locally, but fail in mock/koji
%global enable_tests 0

Name:		nodejs-babel-code-frame
Version:	6.26.0
Release:	alt1_5
Summary:	Generate errors that contain a code frame that point to source locations

License:	MIT
URL:		https://github.com/babel/babel/tree/master/packages/babel-code-frame
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	%{packagename}-tests-%{version}.tar.bz2
Source10:	dl-babel-tests.sh

# license file is in main "babel" directory, not each individual sub-package
Source11:	https://github.com/babel/babel/blob/master/LICENSE

Patch0:		nodejs-babel-code-frame_use-requires.patch


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(chalk)
BuildRequires:	npm(esutils)
BuildRequires:	npm(js-tokens)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Generate errors that contain a code frame that point to source locations.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package
%patch0 -p1

cp -p %{SOURCE11} .

%nodejs_fixdep js-tokens '^4.0.0'

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
