Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npm_name buble

# Several tests are currently failing for an unknown reason
%global enable_tests 0

Name:		nodejs-buble
Version:	0.20.0
Release:	alt1_9
Summary:	The blazing fast, batteries-included ES2015 compiler

License:	MIT
URL:		https://gitlab.com/Rich-Harris/buble
Source0:	https://registry.npmjs.org/%{npm_name}/-/%{npm_name}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source2:        %{npm_name}-%{version}-nm-prod.tgz
Source4:        %{npm_name}-%{version}-bundled-licenses.txt
Source10:	dl-tests.sh
# Config file for rollup
Source11:	https://gitlab.com/Rich-Harris/buble/raw/master/rollup.config.js


BuildArch:	noarch

BuildRequires:	node-devel rpm-build-nodejs
Source44: import.info

%description
The blazing fast, batteries-included ES2015 compiler


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package

cp -p %{SOURCE11} .

#fix script interpreter
sed -i '1s/env //' bin/buble

cp %{SOURCE4} .
# Setup bundled runtime(prod) node modules
tar xfz %{SOURCE2}
mkdir -p node_modules
pushd node_modules
ln -s ../node_modules_prod/* .
ln -s ../node_modules_prod/.bin .
popd


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npm_name}
cp -pr package.json *.js bin/ dist/ \
	%{buildroot}%{nodejs_sitelib}/%{npm_name}
# Copy over bundled nodejs modules
cp -pr node_modules node_modules_prod \
    %{buildroot}%{nodejs_sitelib}/%{npm_name}

mkdir %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{npm_name}/bin/%{npm_name} \
    %{buildroot}%{_bindir}/%{npm_name}

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.md %{npm_name}-%{version}-bundled-licenses.txt
%{nodejs_sitelib}/%{npm_name}
%{_bindir}/%{npm_name}

%changelog
