Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-connect
Version:    3.6.5
Release:    alt1_5
Summary:    High performance middleware framework for Node.js
License:    MIT
URL:        https://github.com/senchalabs/connect
Source0:    https://registry.npmjs.org/connect/-/connect-%{version}.tgz
# The test folder was not included in the npm tarball. Source1 is generated by
# running Source10, which pulls from the upstream version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(debug)
BuildRequires:  npm(finalhandler)
BuildRequires:  npm(parseurl)
BuildRequires:  npm(utils-merge)
%if 0%{?enable_tests}
BuildRequires:  mocha
BuildRequires:  npm(should)
BuildRequires:  npm(should-http)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
Connect is an extensible HTTP server framework for node, providing high
performance "plugins" known as middleware.

Connect is bundled with over 20 commonly used middleware, including a logger,
session support, cookie parser, and more.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%nodejs_fixdep debug
%nodejs_fixdep finalhandler '^1.1.0'

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/connect

cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/connect

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec \
    --timeout 600 --require should-http test/*.js --bail
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/connect


%changelog
