Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-dep-graph
Version:    1.1.0
Release:    alt1_17
Summary:    Simple dependency graph management in JavaScript
# License text is included in README.mdown
License:    MIT
URL:        https://github.com/TrevorBurnham/dep-graph
Source0:    http://registry.npmjs.org/dep-graph/-/dep-graph-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  coffee-script
BuildRequires:  npm(watchit)
BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(nodeunit)
BuildRequires:  npm(underscore)
%endif
Source44: import.info

%description
This is a Node.js module for simple dependency graph management in JavaScript.

Say you have a set of resources that depend on each other in some way. These
resources can be anything (eg, files, chains of command etc.).
All that matters is that each one has a unique string identifier, and a list
of direct dependencies.

dep-graph makes it easy to compute "chains" of dependencies, with guaranteed
logical ordering and no duplicates. That's trivial in most cases, but if A
depends on B and B depends on A, a naA.ve dependency graph would get trapped
in an infinite loop. dep-graph throws an error if any such "cycles" are
detected.


%prep
%setup -q -n package
%nodejs_fixdep underscore '^1.4'
# Build these from source instead.
rm -rf lib/


%build
%nodejs_symlink_deps --check
/usr/bin/cake build


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/dep-graph
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/dep-graph

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
/usr/bin/cake test
%endif


%files
%doc README.mdown docs/
%{nodejs_sitelib}/dep-graph


%changelog
