Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
BuildRequires: java-openjdk-headless >= 1.8.0
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global commit f08dbfd8c33d7d5c30d736b5a4ef4d1f361e93ae

%global installdir  %{_jsdir}/highlight.js
%global assetdir    %{_webassetdir}/highlight.js

Name:       nodejs-highlight-js
Version:    8.0.0
Release:    alt1_11
Summary:    Highlight.js syntax highlighting with language auto-detection for Node.js
License:    BSD
URL:        https://github.com/isagalaev/highlight.js
Source0:    https://github.com/isagalaev/highlight.js/archive/%{commit}/%{name}-%{version}.tar.gz
# yuicompressor is not yet available for Fedora.
Patch0:     %{name}-7.5.0-Use-uglifyjs-instead-of-yuicompressor.jar.patch

BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  python3
BuildRequires:  uglify-js
BuildRequires:  web-assets-devel

Requires:   js-highlight-styles = 0:%{version}-%{release}
Source44: import.info

%description
Highlight.js highlights syntax in code examples on blogs, forums and, in fact,
on any web page. It's very easy to use because it works automatically: finds
blocks of code, detects a language, and highlights it.


%package -n js-highlight
Group: Development/Other
Summary:    Highlight.js syntax highlighting with language auto-detection for the browser
Requires:   web-assets-filesystem
Requires:   js-highlight-styles = 0:%{version}-%{release}

%description -n js-highlight
Highlight.js highlights syntax in code examples on blogs, forums and, in fact,
on any web page. It's very easy to use because it works automatically: finds
blocks of code, detects a language, and highlights it.


%package -n js-highlight-styles
Group: Development/Other
Summary:    Stylesheets for use with highlight.js
Requires:   web-assets-filesystem

%description -n js-highlight-styles
Stylesheets for use with the js-highlight and nodejs-highlight-js packages.


%prep
%setup -q -n highlight.js-%{commit}
#patch0 -p1
#rm -f tools/yuicompressor.jar


%build
# This creates build/lib/* and build/{package.json,LICENSE,README.md}
/usr/bin/python3 tools/build.py -t node
mv build node

# This creates build/highlight.pack.js
/usr/bin/python3 tools/build.py
mv build browser


%install
# Install stylesheets
mkdir -p %{buildroot}%{assetdir}
cp -pr src/styles \
    %{buildroot}%{assetdir}

# Install Node.js version
mkdir -p %{buildroot}%{nodejs_sitelib}/highlight.js
pushd node
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/highlight.js
ln -sf %{assetdir}/styles \
    %{buildroot}%{nodejs_sitelib}/highlight.js/styles
popd

# Install browser version
mkdir -p %{buildroot}%{installdir}
pushd browser
cp -pr highlight.pack.js \
    %{buildroot}%{installdir}
ln -sf %{assetdir}/styles \
    %{buildroot}%{installdir}/styles
popd

%nodejs_symlink_deps


%files
%doc LICENSE README.md
%{nodejs_sitelib}/highlight.js

%files -n js-highlight
%doc LICENSE README.md
%{installdir}

%files -n js-highlight-styles
%{assetdir}


%changelog
