Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0

%global barename js-base64

Name:               nodejs-js-base64
Version:            2.1.7
Release:            alt1_12
Summary:            Yet another Base64 transcoder in pure-JS

License:            BSD
URL:                https://www.npmjs.org/package/js-base64
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz

# The license actually BSD https://github.com/dankogai/js-base64/issues/18
Source1:            https://raw.githubusercontent.com/dankogai/js-base64/master/LICENSE.md

BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel


%if 0%{?enable_tests}
BuildRequires:      npm(mocha)
%endif
Source44: import.info

%description
Yet another Base64 transcoder

%prep
%setup -q -n package

# Copy our Fedora-shipped license file in
cp -pr %{SOURCE1} .

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/js-base64
cp -pr package.json base64.js \
    %{buildroot}%{nodejs_sitelib}/js-base64

%nodejs_symlink_deps

%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
mocha
%endif

%files
%doc README.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/js-base64/

%changelog
