Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# Not all dependencies have been satisfied yet.
%global enable_tests 0

Name:       nodejs-jscoverage
Version:    0.3.8
Release:    alt1_12
Summary:    A JavaScript coverage tool for Node.js and browser development
License:    MIT
URL:        https://github.com/fishbar/jscoverage
Source0:    http://registry.npmjs.org/jscoverage/-/jscoverage-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(expect.js)
BuildRequires:  npm(mocha)
BuildRequires:  npm(optimist)
BuildRequires:  npm(xfs)
BuildRequires:  uglify-js1
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%nodejs_fixdep uglify-js '1.3.x'
%nodejs_fixdep optimist '~0.4'
# Some files are executable that don't need to be.
find -type f -iname '*.js' -exec chmod 644 '{}' \;


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/jscoverage
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/jscoverage
mkdir -p %{buildroot}%{nodejs_sitelib}/jscoverage/bin
install -p -D -m0755 bin/jscoverage \
    %{buildroot}%{nodejs_sitelib}/jscoverage/bin/jscoverage
mkdir -p %{buildroot}%{_bindir}
ln -s %{nodejs_sitelib}/jscoverage/bin/jscoverage %{buildroot}%{_bindir}

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha test/test.js
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/jscoverage
%{_bindir}/jscoverage


%changelog
