Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename needle
# Tests disabled until npm(jschardet) is packaged
%global enable_tests 0

Name:		nodejs-needle
Version:	1.5.2
Release:	alt1_8
Summary:	The leanest and most handsome HTTP client in the Nodelands

License:	MIT
# License file requested upstream at https://github.com/tomas/needle/issues/152
URL:		https://github.com/tomas/needle.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Patch0:		nodejs-needle_fix-tests.patch

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(debug)
%if 0%{?enable_tests}
BuildRequires:	npm(jschardet)
BuildRequires:	npm(q)
BuildRequires:	npm(should)
BuildRequires:	npm(sinon)
BuildRequires:	npm(xml2js)
BuildRequires:	node-mocha
%endif

Requires:	node
Source44: import.info

%description
The leanest and most handsome HTTP client in the Nodelands.


%prep
%setup -q -n package
%patch0 -p1

# fix script interpreter
sed -i '1s;env node;node;' bin/needle

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json  lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}/bin
install -p -D -m0755 bin/needle %{buildroot}%{nodejs_sitelib}/%{packagename}/bin/needle

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/bin/needle \
    %{buildroot}%{_bindir}/needle


%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
mkdir -p test/keys
openssl genrsa -out test/keys/ssl.key 2048
openssl req -new -key test/keys/ssl.key -x509 -subj /CN=test@example.com -days \
999 -out test/keys/ssl.cert
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md examples/
%doc --no-dereference license.txt
%{nodejs_sitelib}/%{packagename}
%{_bindir}/needle



%changelog
