Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename package-license
%global enable_tests 1

Name:		nodejs-package-license
Version:	0.4.1
Release:	alt1_10
Summary:	Checks the filesystem for potential license files

License:	ASL 2.0
URL:		https://github.com/AceMetrix/package-license
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(underscore)

%if 0%{?enable_tests}
# nothing
%endif
Source44: import.info

%description
Checks the filesystem for potential license files and attempts to detect what
they are


%prep
%setup -q -n package


%nodejs_fixdep underscore

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
echo -e "\e[102m -=#=- This package has no tests -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
