Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-superagent
Version:    0.17.0
Release:    alt1_21
Summary:    A small, progressive client-side HTTP request library
License:    MIT
URL:        https://github.com/visionmedia/superagent
Source0:    http://registry.npmjs.org/superagent/-/superagent-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh
# https://raw.github.com/visionmedia/superagent/35a2123271f202e8a6c545a31589955052b3d1f4/LICENSE
Source20:   LICENSE

# Rename emitter-component to component-emitter.
# https://github.com/visionmedia/superagent/pull/335
Patch0:     %{name}-0.9.0-Rename-emitter-component.patch
# Update should and fix tests.
# https://github.com/visionmedia/superagent/pull/334
Patch1:     %{name}-0.9.0-Update-should-and-fix-tests.patch
# Update qs which fixes failing tests on Node.js 0.11.x.
# https://github.com/visionmedia/superagent/pull/334
Patch2:     %{name}-0.9.0-Update-qs-which-fixes-failing-tests-on-Node-0.11.x.patch
# Update express which fixes failing tests on Node.js 0.11.x.
# https://github.com/visionmedia/superagent/pull/334
Patch3:     %{name}-0.9.0-Update-express.patch
# Remove dependency on npm(extend) which would be difficult to package (as it
# is just a copy of two jQuery routines).
# https://github.com/visionmedia/superagent/pull/336
Patch4:     %{name}-0.9.0-Remove-dependency-on-extend-module.patch
# Fix tests for newer should.js
Patch5:     %{name}-shouldjs.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  mocha node-mocha
BuildRequires:  npm(better-assert)
BuildRequires:  npm(component-emitter)
BuildRequires:  npm(cookiejar)
BuildRequires:  npm(debug)
BuildRequires:  npm(express)
BuildRequires:  npm(formidable)
BuildRequires:  npm(methods)
BuildRequires:  npm(mime)
BuildRequires:  npm(qs)
BuildRequires:  npm(reduce-component)
BuildRequires:  npm(should)
BuildRequires:  npm(should-http)
%endif
Source44: import.info

%description
A small, progressive client-side HTTP request library crafted for flexibility,
readability, and a low learning curve.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%patch0 -p1 -b .emitter
%patch1 -p1 -b .should
%patch2 -p1 -b .qs -F 1
%patch3 -p1 -b .express
%patch4 -p1 -b .extend
%patch5 -p1 -b .should2

cp -p %{SOURCE20} .

%nodejs_fixdep qs '~0.6.6'
%nodejs_fixdep formidable
%nodejs_fixdep mime '~2.0.3'
%nodejs_fixdep component-emitter '^1.0'
%nodejs_fixdep methods
%nodejs_fixdep cookiejar
%nodejs_fixdep debug '^2.2.0'
%nodejs_fixdep reduce-component '~1.0.1'
%nodejs_fixdep qs '^6.0.2'

%nodejs_fixdep --dev should-http



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/superagent
cp -pr package.json lib/ superagent.js \
    %{buildroot}%{nodejs_sitelib}/superagent

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
NODE_ENV=test /usr/bin/mocha --require should --reporter spec \
    --timeout 5000 --growl --require should-http test/node/*.js
%endif


%files
%doc History.md Readme.md docs/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/superagent


%changelog
