# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pdumpfs
Version:        1.3
Release:        alt1_15
Summary:        Daily backup system which preserves every daily snapshot 
Group:          File tools
License:        GPLv2
URL:            http://0xcc.net/pdumpfs/
Source0:        %{name}-%{version}.tar.gz
Patch1:		pdumpfs-ruby192.patch
Patch2:		pdumpfs-fix-tests-on-first-day-of-the-month.patch
BuildRequires:  pkgconfig(ruby) 
BuildArch:      noarch
Source44: import.info

%description
pdumpfs is a simple daily backup system similar to Plan9's dumpfs which 
preserves every daily snapshot. pdumpfs is written in Ruby. You can access 
the past snapshots at any time for retrieving a certain day's file. 

pdumpfs constructs the snapshot YYYY/MM/DD in the destination directory. All 
source files are copied to the snapshot directory for the first time. On and 
after the second time, pdumpfs copies only updated or newly created files and 
stores unchanged files as hard links to the files of the previous day's 
snapshot for saving a disk space.

%prep
%setup -q
%patch1 -p1
%patch2 -p1


%build
%make_build
# add a correct shebang at the beggining of the file
perl -pi -e '$. == 1 && print "#\!/usr/bin/ruby\n"' pdumpfs

%check
make check

%install
mkdir -p $RPM_BUILD_ROOT/%_bindir/
chmod 0755 pdumpfs
cp pdumpfs  $RPM_BUILD_ROOT/%_bindir/

mkdir -p $RPM_BUILD_ROOT/%_mandir/
cp -R  man/man8 $RPM_BUILD_ROOT/%_mandir/

%files
%doc doc ChangeLog README
%_bindir/*
%_mandir/man8/*




%changelog
