%define module_name ARGV-OrDATA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Let the diamond operator read from DATA if there's no ARGV
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHOROBA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Tell your script it should use the DATA section if there's no input
coming from STDIN and there are no arguments.

You can also specify which package's DATA should be read instead of
the caller's:

    use My::Module;
    use ARGV::OrDATA 'My::Module';

    while (<>) {  # This reads from My/Module.pm's DATA section.

To restore the old behaviour, you can call the `unimport' method.

    use ARGV::OrDATA;

    my $from_data = <>;

    @ARGV = 'file1.txt';  # Ignored.

    'ARGV::OrDATA'->unimport;

    @ARGV = 'file2.txt';  # Works.

    my $from_file2 = <>;

Calling `import' after `unimport' would restore the DATA handle, but
wouldn't rewind it, i.e. it would continue from where you stopped
(see t/04-unimport.t).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
