# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Acme-CPANModules-JSONVariants
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: List of JSON variants/extensions
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-JSONVariants

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
JSON is hugely popular, yet very simple. This has led to various extensions or
variants of JSON.

An overwhelmingly popular extension is comments, because JSON is used a lot in
configuration. Another popular extension is dangling (trailing) comma.

This list catalogs the various JSON variants which have a Perl implementation on
CPAN.

1) JSON5. https://json5.org/, "JSON for Humans". Allowing more
whitespaces, single-line comment (C++-style), multiline comment (C-style),
single quote for strings, hexadecimal number literal (e.g. 0x123abc), leading
decimal point, trailing decimal point, positive sign in number, trailing commas.

Perl modules: the JSON5 manpage, the File::Serialize::Serializer::JSON5 manpage.

2) HJSON. https://hjson.org, Human JSON. A JSON variant that aims to be
more user-friendly by allowing comments, unquoted keys, and optional commas.
It's designed to be easier to read and write by humans.

Perl modules: (none so far).

3) JSONC. https://github.com/komkom/jsonc. JSON with Comments. Also allows
unquoted string values with whitespace as delimiters.

Perl modules: (none so far).

4) jsonc. https://code.visualstudio.com/docs/languages/json#_json-with-comments.
Another "JSON with Comments", supported by Microsoft Visual Code.

Perl modules: (none so far).

5) CSON. https://github.com/bevry/cson. CofeeScript Object Notation.
JSON-like data serialization format inspired by CoffeeScript syntax. It allows
for a more concise representation of data by leveraging CoffeeScript's features
such as significant whitespace and optional commas.

Perl modules: (none so far).

6) RJSON. https://relaxedjson.org/. Relaxed JSON. Trailing commas,
Optional commas, comments (C-style and C++-style), single-quoted &
backtick-quoted strings as well as bare/unquoted, hash key without value (value
will default to `undef'). It touts itself as "going beyond other JSON variants,
including JSON5."

Perl modules: the JSON::Relaxed manpage.

7) the JSON::Diffable manpage. Basically just allowing for trailing commas.

8) JSO...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%changelog
