BuildRequires: perl(Inline/C.pm)
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Inline.pm) perl(Inline/MakeMaker.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.14
%define module_name Algorithm-SISort
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt7
Summary: Select And Insert sorting algorithm
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HR/HRAFNKELL/%{module_name}-%{module_version}.tar.gz

%description
This module implements a sorting algorithm I saw in BIT 28 (1988) by Istv.n
Beck and Stein Krogdahl. This implementation is mainly intended to try out the
Inline module by Brian Ingerson. The algorithm is a combination of *Straight
Insertion Sort* and *Selection Sort*. While *Insertion Sort* and *Selection
Sort* both are of complexity O(n**2), *Select and Insert Sort* should have
complexity O(n**1.5).

This module defines the functions `Sort' and `Sort_inplace', which have
signatures similar to the internal `sort' function. The difference is that a
codref defining a comparison is always required and that the two values to
compare are always passed in `@_' and not as `$a' and `$b'. (Although I
might change that later.)

`Sort' returns a sorted copy if the array, but `Sort_inplace' sorts the array
in place (as the name suggests) and returns the number of comparisons done. 
(Note that the sorting is always done in place, `Sort' just copies the array
before calling the internal sort routine.)


%prep
%setup -n %{module_name}-%{module_version}
mkdir Algorithm
cp SISort.pm Algorithm/

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/A*

%changelog
