# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(IPC/Open2.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Android-ADB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: thin wrapper over the 'adb' command
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a minimal wrapper over the Android Debug Bridge
(`adb') command for manipulating Android devices.

Methods die on non-zero exit code and return the text printed by the
`adb' command. The available methods are:

=over

=item Android::ADB->new([*args*])

Create a new Android::ADB object. The available arguments are `path',
the path to the `adb' executable (defaults to the value of the
environment variable `ADB' or the string `adb') and `args', an
arrayref of arguments passed to every adb command (defaults to []).

=item $adb->devices

Returns a list of the Android::ADB::Device manpage objects representing
connected devices.

=item $adb->set_device(*$device*)

Takes an the Android::ADB::Device manpage and directs all further commands to
that device by passing `-s serialno' to every command.

=item $adb->run(*$command*, [*@args*])

Run an arbitrary ADB command and return its output.

=item $adb->start_server

=item $adb->kill_server

=item $adb->connect(*$host_and_port*)

=item $adb->disconnect([*$host_and_port*])

=item $adb->wait_for_device

=item $adb->get_state

=item $adb->get_serialno

=item $adb->get_devpath

=item $adb->remount

=item $adb->reboot([*$where*])

=item $adb->reboot_bootloader

=item $adb->root

=item $adb->usb

=item $adb->tcpip(*$port*)

=item $adb->push(*$local*, *$remote*)

=item $adb->pull(*$remote*, *$local*)

=item $adb->shell(*@args*)

Analogues of the respective adb commands.

=item $adb->pull_archive(*$remote*, *$local*)

Same as `adb pull -a $remote $local'.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
