Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(EV.pm) perl(XML/DOM/XPath.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-AnyEvent-XMPP
Version:        0.55
Release:        alt2_32
Summary:        Implementation of the XMPP Protocol
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/AnyEvent-XMPP
Source0:        https://cpan.metacpan.org/authors/id/M/MS/MSTPLBG/AnyEvent-XMPP-%{version}.tar.gz
Patch0:         AnyEvent-XMPP-0.51-timezone.patch
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(AnyEvent.pm)
BuildRequires:  perl(AnyEvent/Handle.pm)
BuildRequires:  perl(AnyEvent/Socket.pm)
BuildRequires:  perl(Authen/SASL.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Digest/SHA.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(MIME/Base64.pm)
BuildRequires:  perl(Net/LibIDN.pm)
BuildRequires:  perl(Object/Event.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Time/Local.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/Parser/Expat.pm)
BuildRequires:  perl(XML/Twig.pm)
BuildRequires:  perl(XML/Writer.pm)
# Add Net::SSLeay to prevent issues like RT#80148
Requires:       perl(Net/SSLeay.pm) >= 1.330


Source44: import.info

%description
AnyEvent::XMPP - An implementation of the XMPP Protocol.

%prep
%setup -q -n AnyEvent-XMPP-%{version}
%patch0  -p1 -b .timezone
for file in samples/*; do
    sed -i 's/#!.*perl/\/usr\/bin\/perl/' ${file}
    chmod a-x ${file}
done

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} +
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes CONTRIBUTORS README TODO samples
%{perl_vendor_privlib}/*

%changelog
