# BEGIN SourceDeps(oneline):
BuildRequires: perl(File/HomeDir.pm) perl(IO/Interactive.pm) perl(Module/Build/Tiny.pm) perl(MooseX/App/Simple.pm) perl(Net/Amazon/EC2.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name App-Goto2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Easily SSH to many servers
Group: Development/Perl
License: perl
URL: https://github.com/oneandoneis2/App-Goto2

Source0: http://cpan.org.ua/authors/id/O/ON/ONEONETWO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
App::Goto2 is intended to take the strain out of having a large number of servers you
frequently have to access via SSH. It allows you to set up nicknames, use partial hostnames,
and auto-detect available AWS EC2 instances and work out which one(s) you actually want. It
also allows for iterating over a number of machines one after the other, and the specification
of an optional command to be run on the remote machine(s).

Written by somebody who frequently had to SSH to a vast number of machines in multiple
domains, with SSH running on numerous ports, with a variety of usernames, using a variety of
SSH keys; and got sick of trying to remember all the details when writing for loops to
remotely execute commands on them all.

You can get a lot of the same functionality (port/user/aliases/etc) just by updating your
ssh config file, but (a) it's harder to share a config file, (b) it wouldn't have the EC2
integration and (c) it doesn't lend itself to wildcards so well.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*

%changelog
