%define module_name App-PhotoDB
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Utils.pm) perl(Config/IniHash.pm) perl(DB/SQL/Migrations.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(Exporter.pm) perl(File/Basename.pm) perl(Getopt/Long.pm) perl(Image/ExifTool.pm) perl(Module/Build.pm) perl(Path/Iterator/Rule.pm) perl(Perl/Critic.pm) perl(Pod/Select.pm) perl(SQL/Abstract.pm) perl(Term/ReadKey.pm) perl(Term/ReadLine.pm) perl(Term/ReadLine/Perl.pm) perl(Test/Compile.pm) perl(Test/Expect.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Test/Perl/Critic.pm) perl(Text/TabularDisplay.pm) perl(Time/Piece.pm) perl(YAML.pm) perl(experimental.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: App to manage a collection of film cameras & lenses
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JG/JGAZELEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PhotoDB is an attempt to create a database for film photography that can be used to track cameras, lenses, accessories, films, negatives and prints, to fully
catalogue a collection of photographic equipment as well as the pictures that are made with them. Read the CONCEPTS section for full details on the
capabilities of PhotoDB.

PhotoDB can also write EXIF tags to scanned images taken with film cameras, so they appear in your digital photo library with the correct metadata (time, date,
focal length, geotag, etc).

At the moment, the PhotoDB project is unfinished and the code continues to change unpredictably. Look for a tagged release in the future!

The heart of PhotoDB is the MySQL/MariaDB backend database schema. This is the most complete part of the project and describes all the data that is recorded.

The application is an interactive command-line tool to make it easier to add and edit data in the database. It is not a graphical interface or web application
(but someone with the right enthusiasm and skills could use the logic I've already written to make a basic graphical interface quite quickly).

PhotoDB should be able to run on pretty much any Linux distribution and MacOS as the Perl dependencies are portable. Soon there will be Docker support which
will simplify installation and allow PhotoDB to run anywhere, including on Windows.

The application is not *quite* feature-complete, so for now you may also need to edit parts of the database directly in some circumstances. You can access the
raw database using the MySQL command line, by using an application such as MySQL Workbench or
phpMyAdmin to obtain a GUI for manipulating the tables.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGELOG LICENSE README.pod docs
%perl_vendor_privlib/A*
%_bindir/*

%changelog
