%define module_name App-Scheme79asm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump/Sexp.pm) perl(Data/SExpression.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Scalar/Util.pm) perl(Test/Perl/Critic.pm) perl(re.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: assemble sexp to Verilog ROM for SIMPLE processor
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
SIMPLE is a LISP processor defined in the 1979
Design of LISP-Based Processors paper by Steele and Sussman.

The SIMPLE processor expects input in a particular tagged-pointer
format. This module takes a string containing a sequence of
S-expressions. Each S-expression is a list of one of three types:

`(tag value)', for example `(symbol 2)', represents a value to be
put in memory (for example a number, or a symbol, or a variable
reference). The value must be a number.

`(tag list)', where `list' is of one of these three types,
represents a tagged pointer. In this case, `list' is (recursively)
laid out in memory as per these rules, and a pointer to that location
(and tagged `tag') is put somewhere in memory.

`(tag list1 list2)', where `list1' and `list2' are of one of these
three types (not necessarily the same type). In this case, `list1'
and `list2' are (recursively) laid out in memory such that `list1'
is at position X and `list2' is at position X+1, and a pointer of
type tag and value X is put somewhere in memory.

After this process the very last pointer placed in memory is moved to
the special location 5 (which is where SIMPLE expects to find the
expression to be evaluated).

In normal use a single S-expression will be supplied, representing an
entire program.

The `tag' is either a number, a type, or a primitive.
The available types are:

=over

=item LIST

=item SYMBOL (syn. NUMBER)

=item VAR (syn. VARIABLE)

=item CLOSURE

=item PROC (syn. PROCEDURE)

=item IF (syn. COND, CONDITIONAL)

=item CALL

=item QUOTE (syn. QUOTED)

=back

The available primitives are:

=over

=item MORE

=item CAR

=item CDR

=item CONS

=item ATOM

=item PROGN

=item REVERSE-LIST

=item FUNCALL

=back

The following methods are available:

=over

=item App::Scheme79asm->new([key => value, key => value, ...])

Create a new assembler object. Takes a list of keys and values, here
are the possible keys:

=over

=item type_bits

=item address_bits

A word is made of a type and an address, with the type occupying the
most sig...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
