%define module_version 0.53
%define module_name App-Unix-RPasswd
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Crypt/PasswdMD5.pm) perl(Cwd.pm) perl(Expect.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Net/FTP.pm) perl(Parallel/ForkManager.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Term/ReadKey.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.53
Release: alt1
Summary: Change passwords on UNIX and UNIX-like servers on a simple, 
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NX/NXADM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
App::Unix::RPasswd is an application for changing passwords on UNIX and 
UNIX-like servers on a simple, fast (in parallel) and secure (SSH) way. 
A salt-based retrievable "random" password generator, tied to the supplied 
server names and date, is included. 
This generated passwords, unique for each server, can be generated and
automatically remotely applied. Because the salt is secret and the correct date
string is required, the password for an specific server can only be regenerated 
by authorized personnel.

Perl 5.10 or higher is required.

The program has two modes. The default mode connects to remote targets and 
changes the password (optional) of the specified user (mandatory) on the 
supplied servers (mandatory). Optional valid parameters for this mode are 
sessions, ssh_args, reruns, timeout and debug. The built-in salted password 
generator can be used to create unique 'random' passwords for each server on 
the fly. In this case date (optional) and base (mandatory) are valid parameters 
for this mode.

The "generate_only" mode is used to (re-) generate salted passwords. In this 
mode only date (optional), base (mandatory), sessions (optional) and one of more 
servers (mandatory) are valid parameters.

From a security point of view, it is strongly advised to supply '-' as the base
salt or password on the command line. The program will then ask interactively 
for the base salt or password. This program requires a ssh-key based remote 
root access.

	Usage:
		rpasswd -u <user> -p <password> <server(s)>
		rpasswd -g -b <base salt> -date <YYYYMMDD> <server(s)>

	Options:
		--generate_only|-g: (re-)generate the salted password.
		--user|-u:          remote user name.
		--password|-p:      new password for remote user.
		--base|-b:          base salt for encryption.
		--date|-d:          date in YYYYMMDD format*.
		--ssh_args|-a:      settings for the ssh client*.
		--reruns|-r:        reruns for failed targets*.
		--sessions|-s:      simultaneous sessions*.
		--timeout|-t:       session timeout*.
		--debug:            prints debug output*.
		--help|-h:          print this help screen.
		--version|-v:       prints the version number.

		*: optional

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
