# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Manifest/Skip.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Parser.pm) perl(Pod/Usage.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(local/lib.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name App-local-lib-helper
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Make it easy to run code against a local-lib
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/App-local-lib-helper/

Source0: http://cpan.org.ua/authors/id/J/JJ/JJNAPIORK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is an object which provide the functionality to create a the local::lib manpage
'helper' script in either the currently loaded the local::lib manpage environment or in
a target directory of choice.  By default the script is called `localenv' and
can be used to invoke a command under the the local::lib manpage which it was built
against.  For example, assume you build a the local::lib manpage like so:

    cpanm --local-lib ~/mylib App::local::lib::helper

Note what is happening.  First, you are telling cpanminus to install everything
to a local::lib directory called `~/mylib' (cpanminus behind the scenes uses
the local::lib manpage to do this for you) then you are telling cpanminus to install the
distribution the App::local::lib::helper manpage into that created the local::lib manpage directory.
When the `Makefile.PL' script for the App::local::lib::helper manpage runs, it notices
the fact that it is being asked to install into a locally lib managed directory
and will additionally generate a helper script into `~/mylib/bin' called `localenv'.

Now, if you want to invoke a perl application and use libs installed into 
`~/mylib', you can do so like:

    ~/mylib/bin/localenv perl [SOME COMMAND]

The command `localenv' will make sure the same the local::lib manpage that was active
when the App::local::lib::helper manpage was originally installed is again installed
into the environment before executing the commands passed in `@ARGV'.  Upon
completing the command, the `%%ENV' is restored so that you can use this to fire
off an application against a specific the local::lib manpage without needing to deal
with the details of how to activate the the local::lib manpage or how to make sure
your `%%ENV' stays clean.

The arguments given to `localenv' don't need to be a perl application.  For
example, I often like to open a sub shell under a particular the local::lib manpage
managed directory.

    ~/mylib/bin/localenv bash

Now, if I do:

    perl -V

I'll see that i`~/mylib' has been added to `@INC'.  Additionally, `~/mylib/bin' will
have been added to `$PATH', so that any command line perl applications installed
into the the local::lib manpage (such as `ack' or `cpanm') can be accessed easily.

Another example usage would be when you want to install an application from
CPAN, install it and all its dependencies to a single directory root and 
then run it without a lot of effort.  For example:

    cpanm --local-lib ~/gitalyst-libs Gitalist App::local::lib::helper
    ~/gitalyst-libs/bin/localenv gitalyst-server.pl

And presto! Your cpan installed application is running, fully self-contained to
one root directory all under regular user privileges.

the local::lib manpage does all the real work, but I find this to be the easiest way to
run given code against a the local::lib manpage root.  

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.mkdn Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
