%define module_name App-migrate
# BEGIN SourceDeps(oneline):
BuildRequires: /proc perl(Devel/AssertOS.pm) perl(Devel/CheckOS.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Path/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.6
Release: alt1
Summary: upgrade / downgrade project
Group: Development/Perl
License: mit
URL: https://github.com/powerman/migrate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
If you're looking for command-line tool - see the migrate manpage. This module is
actual implementation of that tool's functionality and you'll need it only
if you're developing similar tool (like the narada-install manpage) to implement
specifics of your project in single perl script instead of using several
external scripts.

This module implements file format (see the section on "SYNTAX") to describe sequence
of upgrade and downgrade operations needed to migrate *something* between
different versions, and API to analyse and run these operations.

The *something* mentioned above is usually some project, but it can be
literally anything - OS configuration in /etc, or overall OS setup
including installed packages, etc. - anything what has versions and need
complex operations to upgrade/downgrade between these versions.
For example, to migrate source code you can use VCS like Git or Mercurial,
but they didn't support empty directories, file permissions (except
executable), non-plain file types (fifo, UNIX socket, etc.), xattr, ACL,
configuration files which must differ on each site, and databases. So, if
you need to migrate anything isn't supported by VCS - you can try this
module/tool.

Sometimes it isn't possible to really downgrade because some data was lost
while upgrade - to handle these situations you should provide a ways to
create complete backup of your project and restore any project's version
from these backups while downgrade (of course, restoring backups will
result in losing new changes, so whenever possible it's better to do some
extra work to provide a way to downgrade without losing any data).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
