%define module_version 1.4
%define module_name App-rainbarf
# BEGIN SourceDeps(oneline):
BuildRequires: /proc perl(English.pm) perl(Getopt/Long.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Storable.pm) perl(Term/ANSIColor.pm) perl(Test/CPAN/Changes.pm) perl(Test/CPAN/Meta.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4
Release: alt1
Summary: CPU/RAM/battery stats chart bar for tmux (and GNU screen)
Group: Development/Perl
License: perl
URL: https://github.com/creaktive/rainbarf

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SY/SYP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Fancy resource usage charts to put into the tmux status line.
The CPU utilization history chart is tinted with the following colors to reflect the system memory allocation:

=over 4

=item * green: free memory;

=item * yellow: active memory;

=item * blue: inactive memory;

=item * red: wired memory on *Mac OS X* / *FreeBSD*; "unaccounted" memory on *Linux*;

=item * cyan: cached memory on *Linux*, buf on *FreeBSD*.

=back

If available, battery charge is displayed on the right.

Just go to https://github.com/creaktive/rainbarf to see some screenshots.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
