# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Archive-Zip-Crypt
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Unpacking of password protected archives for Archive::Zip
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MB/MBETHKE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a little hack that adds the capability to unpack password-protected
archives to the Archive::Zip manpage. It adds a `password()' method to
the Archive::Zip::Member manpage (passwords may be different for different archive
members!) and overwrites a few others so they can use the decryption
functionality, so it may break wit Archive::Zip versions >1.30. This is a pure
Perl implementation and really slow as bit-fiddling stuff in Perl tends to be.

    use Archive::Zip;
    use Archive::Zip::Crypt;

    my $zip = Archive::Zip->new($archive_name) or die "can't unzip";
    foreach my $member_name ($zip->memberNames) {
        my $member = $zip->memberNamed($member_name);
        next if $member->isDirectory;
        $member->password($password);
        my $contents = $zip->contents($member) or die "error accessing $member_name";
    }

Note: it is important to `use Archive::Zip' first, so `Archive::Zip::Crypt'
can smear its bugs all over the former's namespace.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
