%define module_name Assert-Conditional
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(B/Deparse.pm) perl(Carp/Always.pm) perl(Cwd.pm) perl(Env.pm) perl(Exporter.pm) perl(Exporter/ConditionalSubs.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(Hash/Util.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(Math/BigInt.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(POSIX.pm) perl(Pod/Coverage.pm) perl(Scalar/Util.pm) perl(Test/CheckManifest.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Tools/Exception.pm) perl(Tie/Hash.pm) perl(Unicode/Collate.pm) perl(Unicode/Normalize.pm) perl(charnames.pm) perl(namespace/autoclean.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010
Release: alt1
Summary: conditionally compile assertions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMC/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
C programmers have always had assert.h to conditionally compile assertions
into their programs, but options available for Perl programmers are
not so convenient.  Several assertion modules related to assertions exist on CPAN,
but none works quite like this one does, probably due to differing design goals.

Here are the design goals for `Assert::Conditional':

=over

=item * 

Make easy things easy: by making assertions so easy to write and so cheap
to use, no one will have any reason not to use them.  

=item *

Pass as few arguments as you can to each assertion, and don't require
an easily forgotten `... if DEBUG()' to disable them.

=item *

Create a rich set of assertions related to Perl code to check things 
such as calling context, argument numbers and times, and various other
assumptions about the code or the data.  

These not only provide sanity checks while running, they also help make the
code more readable.  If a boolean test were all that one ever needed, there
would only ever be a `test_ok' function.  Richer function names are
better.

=item *

Provide descriptive failure messages that help pinpoint the exact
error, not just "assertion failed".

=item *

Make assertions that can be made to disappear from your program
without any runtime cost if needed, yet which can also be re-enabled
through a runtime mechanism without touching the code.

=item *

Provide a way for assertions to be run and checked, but which
are not fatal to the program.  (Raise no exception.)

=item *

Allow assertions to be enabled or disabled either *en masse* or piecemeal,
picking and choosing from sets of related assertions to enable or disable.
In other words, make them work a bit like lexical warnings where you can
say give me all of this group, except for these ones.

=item *

Require no complicated framework setup to use: no hierarchy 
of types, no strange magic at a distant, and no 450-module toolchain
from CPAN to get up and running.

=item *

Make it obvious what went wrong.  Don't obfuscate.  Don't generate 100-line
stack dumps filled mostly with anonymous functions and values that make you
think you've accidentally started programming in Java instead of Perl.

=item * 

Keep the implementation of each assertion as short and simple as possible.
This documentation is much longer than the code itself.

=item * 

Use nothing but Standard Perl unless at great need.

=item * 

Compatible to Perl version 5.10 whenever possible.

=back

This initial alpha release is considered completely experimental, but evne
so all these goals have been met.  The only module required that is not
part of the standard Perl release is the underlying
the Exporter::ConditionalSubs manpage which this module inherits its import method
from.  That module is where (most of) the magic happens to make assertions 
get compiled out of your program.  You should look at that module for 
how the "conditional importing" works.
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
